/*
 * Decompiled with CFR 0.152.
 */
package org.jbookreader.ui.swing;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.LineMetrics;
import java.awt.geom.Rectangle2D;
import org.jbookreader.formatengine.IBookPainter;
import org.jbookreader.formatengine.ITextFont;
import org.jbookreader.formatengine.model.RenderingDimensions;

public class SwingBookPainter
implements IBookPainter {
    private double myWidth;
    private double myHeight;
    private Graphics2D myGraphics;
    private float myCurrentX;
    private float myCurrentY;

    public void setGraphics(Graphics2D graphics2D, double d, double d2) {
        this.myGraphics = graphics2D;
        this.myWidth = d;
        this.myHeight = d2;
        this.myCurrentY = 0.0f;
        this.myCurrentX = 0.0f;
    }

    public void clear() {
        this.myGraphics.setColor(this.myGraphics.getBackground());
        this.myGraphics.fill(this.myGraphics.getClip());
        this.myGraphics.setColor(Color.BLACK);
        this.myGraphics.drawRect(0, 0, (int)this.myWidth - 1, (int)this.myHeight - 1);
        this.myCurrentY = 0.0f;
        this.myCurrentX = 0.0f;
    }

    public double getHeight() {
        return this.myHeight;
    }

    public double getWidth() {
        return this.myWidth;
    }

    public RenderingDimensions calculateStringDimensions(String string, int n, int n2, ITextFont iTextFont) {
        TextFontImpl textFontImpl = (TextFontImpl)iTextFont;
        Font font = textFontImpl.getFont();
        FontRenderContext fontRenderContext = this.myGraphics.getFontRenderContext();
        LineMetrics lineMetrics = font.getLineMetrics(string, n, n2, fontRenderContext);
        Rectangle2D rectangle2D = font.getStringBounds(string, n, n2, fontRenderContext);
        return new RenderingDimensions(lineMetrics.getAscent(), lineMetrics.getDescent(), rectangle2D.getMaxX() - rectangle2D.getMinX());
    }

    public void renderString(String string, int n, int n2, ITextFont iTextFont, RenderingDimensions renderingDimensions) {
        TextFontImpl textFontImpl = (TextFontImpl)iTextFont;
        Font font = textFontImpl.getFont();
        if (!this.myGraphics.getFont().equals(font)) {
            this.myGraphics.setFont(font);
        }
        this.myGraphics.setColor(Color.BLACK);
        this.myGraphics.drawString(string.substring(n, n2), this.myCurrentX, this.myCurrentY);
        this.myCurrentX = (float)((double)this.myCurrentX + renderingDimensions.width);
    }

    public void addHorizontalStrut(double d) {
        this.myCurrentX = (float)((double)this.myCurrentX + d);
    }

    public void addVerticalStrut(double d) {
        this.myCurrentY = (float)((double)this.myCurrentY + d);
    }

    public void flushString() {
        this.myCurrentX = 0.0f;
    }

    public ITextFont getFont(String string, int n) {
        return new TextFontImpl(string, n);
    }

    public double getYCoordinate() {
        return this.myCurrentY;
    }

    private class TextFontImpl
    implements ITextFont {
        private final Font myFont;
        private double mySpaceWidth = 0.0;

        public TextFontImpl(String string, int n) {
            this.myFont = new Font(string, 0, n);
        }

        public double getSpaceWidth() {
            if (this.mySpaceWidth == 0.0) {
                FontRenderContext fontRenderContext = SwingBookPainter.this.myGraphics.getFontRenderContext();
                GlyphVector glyphVector = this.myFont.createGlyphVector(fontRenderContext, new char[]{' '});
                Rectangle2D rectangle2D = glyphVector.getLogicalBounds();
                this.mySpaceWidth = rectangle2D.getMaxX() - rectangle2D.getMinX();
            }
            return this.mySpaceWidth;
        }

        public Font getFont() {
            return this.myFont;
        }
    }
}

