/*
 * Decompiled with CFR 0.152.
 */
package org.jbookreader.ui.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import org.jbookreader.book.bom.IBook;
import org.jbookreader.book.parser.FB2Parser;
import org.jbookreader.ui.swing.JBookComponent;
import org.jbookreader.ui.swing.Messages;
import org.jbookreader.ui.swing.actions.OpenAction;
import org.jbookreader.ui.swing.actions.PageDownAction;
import org.jbookreader.ui.swing.actions.QuitAction;
import org.jbookreader.ui.swing.actions.ScrollDownAction;
import org.jbookreader.ui.swing.actions.ScrollUpAction;
import org.xml.sax.SAXException;

public class MainWindow {
    private JBookComponent myBookComponent;
    private JFrame myFrame = new JFrame();
    private static MainWindow ourWindow;

    private JComponent createContents() {
        JPanel jPanel = new JPanel(new BorderLayout());
        this.myBookComponent = new JBookComponent();
        this.myBookComponent.setOpaque(true);
        Dimension dimension = new Dimension(200, 100);
        jPanel.add((Component)this.myBookComponent, "Center");
        jPanel.setMinimumSize(dimension);
        jPanel.setPreferredSize(dimension);
        return jPanel;
    }

    private JMenuBar createMenuBar() {
        JMenuBar jMenuBar = new JMenuBar();
        jMenuBar.add(this.createFileMenu());
        jMenuBar.add(this.createEditMenu());
        jMenuBar.add(this.createViewMenu());
        jMenuBar.add(this.createBookmarksMenu());
        jMenuBar.add(this.createHelpMenu());
        return jMenuBar;
    }

    private JMenu createFileMenu() {
        JMenu jMenu = new JMenu(Messages.getString("File"));
        jMenu.setMnemonic(70);
        JMenuItem jMenuItem = new JMenuItem(OpenAction.getAction());
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        jMenu.add(jMenuItem);
        jMenu.add(new JSeparator());
        jMenuItem = new JMenuItem(QuitAction.getAction());
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(81, 2));
        jMenu.add(jMenuItem);
        return jMenu;
    }

    private JMenu createEditMenu() {
        JMenu jMenu = new JMenu(Messages.getString("Edit"));
        jMenu.setMnemonic(69);
        JMenuItem jMenuItem = new JMenuItem(Messages.getString("Find"), 70);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(70, 2));
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(Messages.getString("FindNext"), 88);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(71, 2));
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(Messages.getString("FindPrevious"), 86);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(71, 3));
        jMenu.add(jMenuItem);
        jMenu.add(new JSeparator());
        jMenuItem = new JMenuItem(Messages.getString("Preferences"), 69);
        jMenu.add(jMenuItem);
        return jMenu;
    }

    private JMenu createViewMenu() {
        JMenu jMenu = new JMenu(Messages.getString("View"));
        jMenu.setMnemonic(86);
        return jMenu;
    }

    private JMenu createBookmarksMenu() {
        JMenu jMenu = new JMenu(Messages.getString("Bookmarks"));
        jMenu.setMnemonic(66);
        JMenuItem jMenuItem = new JMenuItem(Messages.getString("AddBookmark"), 65);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(68, 2));
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(Messages.getString("EditBookmarks"), 69);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(66, 2));
        jMenu.add(jMenuItem);
        jMenu.add(new JSeparator());
        return jMenu;
    }

    private JMenu createHelpMenu() {
        JMenu jMenu = new JMenu(Messages.getString("Help"));
        jMenu.setMnemonic(72);
        JMenuItem jMenuItem = new JMenuItem(Messages.getString("About"), 65);
        jMenu.add(jMenuItem);
        return jMenu;
    }

    public MainWindow() {
        this.myFrame.setTitle("JBookReader");
        this.myFrame.setDefaultCloseOperation(3);
        this.myFrame.setJMenuBar(this.createMenuBar());
        Container container = this.myFrame.getContentPane();
        JComponent jComponent = this.createContents();
        jComponent.setBorder(BorderFactory.createEmptyBorder(7, 7, 7, 7));
        container.add((Component)jComponent, "Center");
        this.myFrame.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(34, 0), PageDownAction.getAction().getValue("Name"));
        this.myFrame.getRootPane().getActionMap().put(PageDownAction.getAction().getValue("Name"), PageDownAction.getAction());
        this.myFrame.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(40, 0), ScrollDownAction.getAction().getValue("Name"));
        this.myFrame.getRootPane().getActionMap().put(ScrollDownAction.getAction().getValue("Name"), ScrollDownAction.getAction());
        this.myFrame.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(38, 0), ScrollUpAction.getAction().getValue("Name"));
        this.myFrame.getRootPane().getActionMap().put(ScrollUpAction.getAction().getValue("Name"), ScrollUpAction.getAction());
        this.myFrame.pack();
    }

    public static MainWindow getMainWindow() {
        if (ourWindow == null) {
            ourWindow = new MainWindow();
        }
        return ourWindow;
    }

    public void openBook(File file) {
        try {
            IBook iBook = FB2Parser.parse(file);
            this.myBookComponent.setBook(iBook);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
        }
    }

    public JFrame getFrame() {
        return this.myFrame;
    }

    public void dispose() {
        this.myFrame.dispose();
    }

    public JBookComponent getBookComponent() {
        return this.myBookComponent;
    }
}

