/*
 * Decompiled with CFR 0.152.
 */
package org.jbookreader.ui.swing;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import javax.swing.JComponent;
import org.jbookreader.book.bom.IBook;
import org.jbookreader.formatengine.FormatEngine;
import org.jbookreader.ui.swing.SwingBookPainter;

public class JBookComponent
extends JComponent {
    private static final long serialVersionUID = -2480969864889318912L;
    private final SwingBookPainter myPainter;
    private final FormatEngine myEngine = new FormatEngine();
    private IBook myBook;
    private boolean myReformatBook;

    public JBookComponent() {
        this.myPainter = new SwingBookPainter();
        this.myEngine.setPainter(this.myPainter);
    }

    public boolean isOpaque() {
        return true;
    }

    protected void paintComponent(Graphics graphics) {
        if (this.isOpaque()) {
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        Insets insets = this.getInsets();
        int n = this.getWidth() - insets.left - insets.right;
        int n2 = this.getHeight() - insets.top - insets.bottom;
        Graphics2D graphics2D = (Graphics2D)graphics.create(insets.left, insets.top, n, n2);
        graphics2D.setBackground(this.getBackground());
        if (this.myPainter.getWidth() != (double)n) {
            this.myReformatBook = true;
        }
        this.myPainter.setGraphics(graphics2D, n, n2);
        if (this.myBook != null) {
            this.myEngine.renderPage(this.myReformatBook);
            this.myReformatBook = false;
        }
        graphics2D.dispose();
    }

    public void setBook(IBook iBook) {
        this.myBook = iBook;
        this.myEngine.setBook(this.myBook);
        this.myReformatBook = true;
        this.repaint();
    }

    public void scrollPageDown() {
        this.myEngine.scrollPageDown();
        this.repaint();
    }

    public void scrollDown(int n) {
        this.myEngine.scrollDown(n);
        this.repaint();
    }

    public void scrollUp(int n) {
        this.myEngine.scrollUp(n);
        this.repaint();
    }
}

