/*
 * Decompiled with CFR 0.152.
 */
package org.jbookreader.formatengine.model;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.jbookreader.book.bom.IContainerNode;
import org.jbookreader.formatengine.model.IRenderingObject;
import org.jbookreader.formatengine.model.RenderingDimensions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Line {
    private final List<IRenderingObject> myRObjects = new LinkedList<IRenderingObject>();
    private double myLeftMargin;
    private double myRightMargin;
    private double myHeight;
    private double myDepth;
    private double myWidth;
    private boolean myFirstLine;
    private IContainerNode myParagraphNode;

    public Line(boolean bl, IContainerNode iContainerNode) {
        this.myFirstLine = bl;
        this.myParagraphNode = iContainerNode;
    }

    public void addObject(IRenderingObject iRenderingObject) {
        this.myRObjects.add(iRenderingObject);
        RenderingDimensions renderingDimensions = iRenderingObject.getDimensions();
        if (renderingDimensions.height > this.myHeight) {
            this.myHeight = renderingDimensions.height;
        }
        if (renderingDimensions.depth > this.myDepth) {
            this.myDepth = renderingDimensions.depth;
        }
        this.myWidth += renderingDimensions.width;
    }

    public List<IRenderingObject> getObjects() {
        return Collections.unmodifiableList(this.myRObjects);
    }

    public double getLeftMargin() {
        return this.myLeftMargin;
    }

    public void setLeftMargin(double d) {
        this.myLeftMargin = d;
    }

    public double getRightMargin() {
        return this.myRightMargin;
    }

    public void setRightMargin(double d) {
        this.myRightMargin = d;
    }

    public double getHeight() {
        return this.myHeight;
    }

    public double getDepth() {
        return this.myDepth;
    }

    public double getWidth() {
        return this.myWidth;
    }

    public IContainerNode getParagraphNode() {
        return this.myParagraphNode;
    }

    public boolean isFirstLine() {
        return this.myFirstLine;
    }
}

