/*
 * Decompiled with CFR 0.152.
 */
package org.jbookreader.formatengine;

import java.util.ArrayList;
import java.util.List;
import org.jbookreader.book.bom.IBook;
import org.jbookreader.book.bom.IContainerNode;
import org.jbookreader.book.bom.INode;
import org.jbookreader.book.stylesheet.EDisplayType;
import org.jbookreader.book.stylesheet.IStyleSheet;
import org.jbookreader.formatengine.IBookPainter;
import org.jbookreader.formatengine.ITextFont;
import org.jbookreader.formatengine.model.HorizontalGlue;
import org.jbookreader.formatengine.model.IRenderingObject;
import org.jbookreader.formatengine.model.Line;
import org.jbookreader.formatengine.model.MetaString;
import org.jbookreader.formatengine.model.RenderingDimensions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormatEngine {
    private IBookPainter myPainter;
    private IBook myBook;
    private List<Line> myLines = new ArrayList<Line>();
    private int myStartLine;
    private int myNextPageLine = -1;
    private static final double BASE_LINE_SKIP = 12.0;
    private static final double LINE_SKIP_LIMIT = 1.0;
    private static final double LINE_SKIP = 1.0;

    public void setPainter(IBookPainter iBookPainter) {
        this.myPainter = iBookPainter;
    }

    public void setBook(IBook iBook) {
        this.myBook = iBook;
        this.myStartLine = 0;
        this.myLines.clear();
    }

    private int consumeWhitespace(String string, int n) {
        while (n < string.length() && string.charAt(n) <= ' ') {
            ++n;
        }
        return n;
    }

    private Line formatNode(List<Line> list, Line line, IContainerNode iContainerNode) {
        block0: for (INode iNode : iContainerNode.getChildNodes()) {
            if (iNode.isContainer()) {
                line = this.formatNode(list, line, (IContainerNode)iNode);
                continue;
            }
            String string = iNode.getText();
            int n = 0;
            int n2 = 0;
            ITextFont iTextFont = this.myPainter.getFont("default", 10);
            while (n2 < string.length()) {
                int n3 = this.consumeWhitespace(string, n);
                if (n3 > n) {
                    double d = iTextFont.getSpaceWidth();
                    if (line.getLeftMargin() + line.getWidth() + d + line.getRightMargin() > this.myPainter.getWidth()) {
                        line = this.flushLine(list, line);
                    } else {
                        line.addObject(new HorizontalGlue(d, this.myPainter));
                    }
                }
                if ((n2 = (n = n3)) >= string.length()) continue block0;
                while (n2 < string.length() && string.charAt(n2) > ' ') {
                    ++n2;
                }
                RenderingDimensions renderingDimensions = this.myPainter.calculateStringDimensions(string, n, n2, iTextFont);
                if (line.getLeftMargin() + line.getWidth() + renderingDimensions.width + line.getRightMargin() > this.myPainter.getWidth() && !line.getObjects().isEmpty()) {
                    line = this.flushLine(list, line);
                }
                line.addObject(new MetaString(string, n, n2, this.myPainter, iTextFont));
                n = n2;
            }
        }
        return line;
    }

    private Line flushLine(List<Line> list, Line line) {
        list.add(line);
        IContainerNode iContainerNode = line.getParagraphNode();
        Line line2 = new Line(false, iContainerNode);
        line2.setLeftMargin(this.myBook.getSystemStyleSheet().getLeftMargin(iContainerNode));
        line2.setRightMargin(this.myBook.getSystemStyleSheet().getRightMargin(iContainerNode));
        return line2;
    }

    private IContainerNode getNextParagraphNode(IContainerNode iContainerNode) {
        int n;
        List<INode> list;
        while (true) {
            IContainerNode iContainerNode2;
            if ((iContainerNode2 = iContainerNode.getParentNode()) == null) {
                return null;
            }
            list = iContainerNode2.getChildNodes();
            n = list.indexOf(iContainerNode);
            if (n == -1) {
                throw new IllegalStateException("Node '" + iContainerNode + "' not found in it's parent list!!!!");
            }
            if (n + 1 < list.size()) break;
            iContainerNode = iContainerNode2;
        }
        iContainerNode = (IContainerNode)list.get(n + 1);
        return this.getFirstParagraphNodeDown(iContainerNode);
    }

    private IContainerNode getPreviousParagraphNode(IContainerNode iContainerNode) {
        int n;
        List<INode> list;
        while (true) {
            IContainerNode iContainerNode2;
            if ((iContainerNode2 = iContainerNode.getParentNode()) == null) {
                return null;
            }
            list = iContainerNode2.getChildNodes();
            n = list.indexOf(iContainerNode);
            if (n == -1) {
                throw new IllegalStateException("Node '" + iContainerNode + "' not found in it's parent list!!!!");
            }
            if (n - 1 >= 0) break;
            iContainerNode = iContainerNode2;
        }
        iContainerNode = (IContainerNode)list.get(n - 1);
        return this.getLastParagraphNodeDown(iContainerNode);
    }

    private IContainerNode getFirstParagraphNodeDown(IContainerNode iContainerNode) {
        IStyleSheet iStyleSheet = iContainerNode.getBook().getSystemStyleSheet();
        while (iContainerNode.isContainer()) {
            List<INode> list = iContainerNode.getChildNodes();
            if (list.isEmpty()) {
                return iContainerNode;
            }
            INode iNode = list.get(0);
            if (iStyleSheet.getNodeDisplayType(iNode) == EDisplayType.INLINE) {
                return iContainerNode;
            }
            if (!iNode.isContainer()) {
                throw new IllegalStateException("child node isn't INLINE, but isn't a container: " + iContainerNode.getTagName() + " -> " + iNode.getTagName());
            }
            iContainerNode = (IContainerNode)iNode;
        }
        return iContainerNode;
    }

    private IContainerNode getLastParagraphNodeDown(IContainerNode iContainerNode) {
        IStyleSheet iStyleSheet = iContainerNode.getBook().getSystemStyleSheet();
        while (iContainerNode.isContainer()) {
            List<INode> list = iContainerNode.getChildNodes();
            if (list.isEmpty()) {
                return iContainerNode;
            }
            INode iNode = list.get(list.size() - 1);
            if (iStyleSheet.getNodeDisplayType(iNode) == EDisplayType.INLINE) {
                return iContainerNode;
            }
            if (!iNode.isContainer()) {
                throw new IllegalStateException("child node isn't INLINE, but isn't a container: " + iContainerNode.getTagName() + " -> " + iNode.getTagName());
            }
            iContainerNode = (IContainerNode)iNode;
        }
        return iContainerNode;
    }

    public void renderPage(boolean bl) {
        IContainerNode iContainerNode = null;
        this.myPainter.clear();
        if (bl) {
            if (this.myStartLine < this.myLines.size()) {
                iContainerNode = this.myLines.get(this.myStartLine).getParagraphNode();
                this.myStartLine = 0;
            }
            this.myLines.clear();
        }
        int n = this.myStartLine;
        double d = 0.0;
        while (this.myPainter.getYCoordinate() < this.myPainter.getHeight()) {
            IRenderingObject iRenderingObject;
            Object object;
            Object object2;
            if (n >= this.myLines.size()) {
                if (this.myLines.size() == 0) {
                    object2 = iContainerNode == null ? this.getFirstParagraphNodeDown(this.myBook.getMainBody()) : iContainerNode;
                } else {
                    object = this.myLines.get(this.myLines.size() - 1).getParagraphNode();
                    object2 = this.getNextParagraphNode((IContainerNode)object);
                }
                if (object2 == null) {
                    if (this.myStartLine >= this.myLines.size()) {
                        n = this.myStartLine = this.myLines.size() - 1;
                        continue;
                    }
                    this.myNextPageLine = this.myStartLine;
                    return;
                }
                object = new Line(true, (IContainerNode)object2);
                ((Line)object).setLeftMargin(this.myBook.getSystemStyleSheet().getFirstLineMargin((INode)object2));
                ((Line)object).setRightMargin(this.myBook.getSystemStyleSheet().getRightMargin((INode)object2));
                object = this.formatNode(this.myLines, (Line)object, (IContainerNode)object2);
                this.myLines.add((Line)object);
            }
            if (d + 1.0 + ((Line)(object2 = this.myLines.get(n))).getHeight() < 12.0) {
                this.myPainter.addVerticalStrut(12.0);
            } else {
                this.myPainter.addVerticalStrut(d + 1.0 + ((Line)object2).getHeight());
            }
            this.myPainter.addHorizontalStrut(((Line)object2).getLeftMargin());
            object = ((Line)object2).getObjects().iterator();
            while (object.hasNext() && (!(iRenderingObject = object.next()).isGlue() || object.hasNext())) {
                iRenderingObject.render();
            }
            this.myPainter.flushString();
            d = ((Line)object2).getDepth();
            ++n;
        }
        this.myNextPageLine = n - 1;
    }

    private void cleanStartLines() {
        int n = this.myStartLine;
        while (!this.myLines.get(n).isFirstLine()) {
            --n;
        }
        for (int i = 0; i < n; ++i) {
            this.myLines.remove(0);
        }
        this.myStartLine -= n;
    }

    public void scrollPageDown() {
        if (this.myNextPageLine < 0) {
            return;
        }
        this.myStartLine = this.myNextPageLine;
        this.cleanStartLines();
    }

    public void scrollDown(int n) {
        this.myStartLine += n;
        this.myNextPageLine = -1;
        if (this.myStartLine >= this.myLines.size()) {
            return;
        }
        if (this.myLines.get(this.myStartLine).isFirstLine()) {
            this.cleanStartLines();
        }
    }

    public void scrollUp(int n) {
        this.myStartLine -= n;
        this.myNextPageLine = -1;
        while (this.myStartLine < 0) {
            IContainerNode iContainerNode = this.getPreviousParagraphNode(this.myLines.get(0).getParagraphNode());
            if (iContainerNode == null) {
                this.myStartLine = 0;
                return;
            }
            ArrayList<Line> arrayList = new ArrayList<Line>();
            Line line = new Line(true, iContainerNode);
            line.setLeftMargin(this.myBook.getSystemStyleSheet().getFirstLineMargin(iContainerNode));
            line.setRightMargin(this.myBook.getSystemStyleSheet().getRightMargin(iContainerNode));
            line = this.formatNode(arrayList, line, iContainerNode);
            arrayList.add(line);
            this.myLines.addAll(0, arrayList);
            this.myStartLine += arrayList.size();
        }
    }
}

