/*
 * Decompiled with CFR 0.152.
 */
package org.jbookreader.book.stylesheet.impl;

import java.util.HashMap;
import java.util.Map;
import org.jbookreader.book.bom.INode;
import org.jbookreader.book.stylesheet.EDisplayType;
import org.jbookreader.book.stylesheet.IStyleSheet;

public class FB2StyleSheet
implements IStyleSheet {
    private Map<String, EDisplayType> myDisplayTypes = new HashMap<String, EDisplayType>();
    private static final String[] FB2_BLOCK_TAGS = new String[]{"body", "section", "title", "p", "empty-line", "abstract", "epigraph"};
    private static final String[] FB2_INLINE_TAGS = new String[]{"strong", "emphasis", "strikethrough", "sub", "sup", "code", "a", "#text"};

    public FB2StyleSheet() {
        for (String string : FB2_INLINE_TAGS) {
            this.myDisplayTypes.put(string, EDisplayType.INLINE);
        }
        for (String string : FB2_BLOCK_TAGS) {
            this.myDisplayTypes.put(string, EDisplayType.BLOCK);
        }
    }

    public EDisplayType getNodeDisplayType(INode iNode) {
        if (this.myDisplayTypes.containsKey(iNode.getTagName())) {
            return this.myDisplayTypes.get(iNode.getTagName());
        }
        System.err.println("Got unknown tag: '" + iNode.getTagName() + "'! Check your parser version, please");
        return EDisplayType.BLOCK;
    }

    public double getLeftMargin(INode iNode) {
        return 5.0;
    }

    public double getFirstLineMargin(INode iNode) {
        return 10.0;
    }

    public double getRightMargin(INode iNode) {
        return 5.0;
    }
}

