/*
 * Decompiled with CFR 0.152.
 */
package org.jbookreader.book.parser;

import java.io.File;
import java.io.IOException;
import org.jbookreader.book.bom.IBinaryData;
import org.jbookreader.book.bom.IBook;
import org.jbookreader.book.bom.IContainerNode;
import org.jbookreader.book.bom.ISectioningNode;
import org.jbookreader.book.bom.impl.Book;
import org.jbookreader.book.parser.ParseErrorHandler;
import org.jbookreader.book.stylesheet.IStyleSheet;
import org.jbookreader.book.stylesheet.impl.FB2StyleSheet;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class FB2Parser {
    public static final String FB2_XMLNS_URI = "http://www.gribuser.ru/xml/fictionbook/2.0";
    private static IStyleSheet ssheet;

    public static IBook parse(String string) throws IOException, SAXException {
        XMLReader xMLReader = XMLReaderFactory.createXMLReader();
        xMLReader.setErrorHandler(new ParseErrorHandler());
        Book book = new Book();
        book.setSystemStyleSheet(FB2Parser.getFB2StyleSheet());
        xMLReader.setContentHandler(new FB2ContentsHandler(book));
        xMLReader.parse(new InputSource(string));
        return book;
    }

    public static IBook parse(File file) throws IOException, SAXException {
        return FB2Parser.parse(file.getAbsolutePath());
    }

    private static IStyleSheet getFB2StyleSheet() {
        if (ssheet == null) {
            ssheet = new FB2StyleSheet();
        }
        return ssheet;
    }

    private static class FB2ContentsHandler
    extends DefaultHandler {
        private Locator myLocator;
        private final IBook myBook;
        private IBinaryData myBinaryData;
        private ISectioningNode mySection;
        private IContainerNode myContainer;
        private StringBuilder myText = new StringBuilder();
        private boolean hadOpenTag = false;
        private boolean parseXML = false;
        private boolean myParseText = false;

        public FB2ContentsHandler(IBook iBook) {
            this.myBook = iBook;
        }

        public void setDocumentLocator(Locator locator) {
            this.myLocator = locator;
        }

        public void startDocument() {
        }

        public void endDocument() {
        }

        public void characters(char[] cArray, int n, int n2) {
            if (!this.parseXML) {
                return;
            }
            if (!this.myParseText) {
                return;
            }
            this.myText.append(cArray, n, n2);
        }

        private void processTextNode(boolean bl) {
            String string = FB2ContentsHandler.trimStringBuilder(this.myText, this.hadOpenTag, bl);
            this.myText.setLength(0);
            if (string.length() == 0) {
                return;
            }
            this.myContainer.newTextNode(string);
        }

        private boolean isParagraphTag(String string) {
            return string.equals("p") || string.equals("subtitle") || string.equals("text-author") || string.equals("v");
        }

        public void endElement(String string, String string2, String string3) {
            if (!this.parseXML) {
                return;
            }
            if (!string2.equals("FictionBook")) {
                if (string2.equals("binary")) {
                    this.myBinaryData.setBase64Encoded(this.myText.toString().toCharArray());
                    this.myBinaryData = null;
                } else {
                    this.processTextNode(true);
                    this.hadOpenTag = false;
                    if (this.isParagraphTag(string2)) {
                        this.myParseText = false;
                    }
                    if (this.myContainer.isSectioningNode()) {
                        this.mySection = this.mySection.getParentSection();
                    }
                    this.myContainer = this.myContainer.getParentNode();
                }
            }
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) {
            if (!this.parseXML) {
                if (!string2.equals("body")) {
                    return;
                }
                this.parseXML = true;
            }
            this.processTextNode(false);
            this.hadOpenTag = true;
            if (!string2.equals("FictionBook")) {
                IContainerNode iContainerNode;
                if (string2.equals("binary")) {
                    this.myBinaryData = this.myBook.newBinaryData(attributes.getValue("id"), attributes.getValue("content-type"));
                    return;
                }
                if (string2.equals("body")) {
                    this.mySection = this.myBook.newBody("body", attributes.getValue("name"));
                    iContainerNode = this.mySection;
                } else if (string2.equals("section")) {
                    this.mySection = this.mySection.newSectioningNode(string2);
                    iContainerNode = this.mySection;
                } else if (string2.equals("title")) {
                    iContainerNode = this.mySection.newTitle(string2);
                } else if (this.isParagraphTag(string2)) {
                    iContainerNode = this.myContainer.newContainerNode(string2);
                    this.myParseText = true;
                } else {
                    iContainerNode = this.myContainer.newContainerNode(string2);
                }
                this.myContainer = iContainerNode;
                String string4 = attributes.getValue("id");
                if (string4 != null) {
                    iContainerNode.setID(string4);
                }
            }
        }

        private static String trimStringBuilder(StringBuilder stringBuilder, boolean bl, boolean bl2) {
            int n;
            int n2 = stringBuilder.length();
            if (n2 == 0 || stringBuilder.charAt(0) > ' ' && stringBuilder.charAt(n2 - 1) > ' ') {
                return stringBuilder.toString();
            }
            int n3 = n2 - 1;
            if (bl) {
                for (n = 0; n <= n3 && stringBuilder.charAt(n) <= ' '; ++n) {
                }
            }
            if (bl2) {
                while (n <= n3 && stringBuilder.charAt(n3) <= ' ') {
                    --n3;
                }
            }
            if (n > n3) {
                return "";
            }
            return stringBuilder.substring(n, n3 + 1);
        }
    }
}

