/*
 * Decompiled with CFR 0.152.
 */
package org.jbookreader.book.bom.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jbookreader.book.bom.IBinaryData;
import org.jbookreader.book.bom.IBook;
import org.jbookreader.book.bom.INode;
import org.jbookreader.book.bom.ISectioningNode;
import org.jbookreader.book.bom.impl.BinaryData;
import org.jbookreader.book.bom.impl.SectioningNode;
import org.jbookreader.book.stylesheet.IStyleSheet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Book
implements IBook {
    private IStyleSheet mySystemStyleSheet;
    private Map<String, ISectioningNode> myBodies = new LinkedHashMap<String, ISectioningNode>();
    private Map<String, INode> myIDmap = new LinkedHashMap<String, INode>();
    private Map<String, BinaryData> myBinaries = new LinkedHashMap<String, BinaryData>();

    @Override
    public ISectioningNode newBody(String string, String string2) {
        SectioningNode sectioningNode = new SectioningNode();
        sectioningNode.setTagName(string);
        sectioningNode.setBook(this);
        this.myBodies.put(string2, sectioningNode);
        return sectioningNode;
    }

    @Override
    public ISectioningNode getMainBody() {
        ISectioningNode iSectioningNode = this.myBodies.get(null);
        if (iSectioningNode == null) {
            throw new IllegalStateException("No main body provided");
        }
        return iSectioningNode;
    }

    @Override
    public Collection<ISectioningNode> getBodies() {
        return Collections.unmodifiableCollection(this.myBodies.values());
    }

    @Override
    public IBinaryData newBinaryData(String string, String string2) {
        BinaryData binaryData = new BinaryData();
        binaryData.setContentType(string2);
        this.myBinaries.put(string, binaryData);
        return binaryData;
    }

    @Override
    public IBinaryData getBinaryData(String string) {
        return this.myBinaries.get(string);
    }

    @Override
    public IStyleSheet getSystemStyleSheet() {
        return this.mySystemStyleSheet;
    }

    @Override
    public void setSystemStyleSheet(IStyleSheet iStyleSheet) {
        this.mySystemStyleSheet = iStyleSheet;
    }

    @Override
    public INode getNodeByID(String string) {
        return this.myIDmap.get(string);
    }

    void mapIdNode(INode iNode) {
        String string = iNode.getID();
        if (string != null) {
            this.myIDmap.put(string, iNode);
        }
    }
}

