/*
 * Decompiled with CFR 0.152.
 */
package jbookreader.util;

import jbookreader.book.IBookFactory;

public final class BookFactoryCreator {
    private static final String DEFAULT_FACTORY_CLASS = "jbookreader.book.impl.BookFactory";
    private static final String PROPERTY_NAME = "jbookreader.book.factory";

    private BookFactoryCreator() {
    }

    public static IBookFactory getBookFactory() {
        String className = null;
        try {
            className = System.getProperty(PROPERTY_NAME);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        if (className == null) {
            className = DEFAULT_FACTORY_CLASS;
        }
        return BookFactoryCreator.getBookFactory(className);
    }

    private static IBookFactory getBookFactory(String className) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        try {
            Class<IBookFactory> klass = loader == null ? Class.forName(className).asSubclass(IBookFactory.class) : loader.loadClass(className).asSubclass(IBookFactory.class);
            return klass.newInstance();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            throw new UnknownError(e.getMessage());
        }
        catch (InstantiationException e) {
            e.printStackTrace();
            throw new UnknownError(e.getMessage());
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            throw new UnknownError(e.getMessage());
        }
    }
}

