/*
 * Decompiled with CFR 0.152.
 */
package jbookreader.rendering.swing;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import javax.swing.Scrollable;
import jbookreader.book.IBook;
import jbookreader.formatengine.ICompositor;
import jbookreader.formatengine.IFormatEngine;
import jbookreader.rendering.IDrawable;
import jbookreader.rendering.IFont;
import jbookreader.rendering.IGraphicDriver;
import jbookreader.rendering.Position;
import jbookreader.rendering.swing.AWTFontAdapter;
import jbookreader.rendering.swing.AWTImageAdapter;
import jbookreader.rendering.swing.SwingString;

public class JGraphicDriver
extends JComponent
implements IGraphicDriver,
Scrollable {
    private static final int PIXEL_SCALE_FACTOR = 100;
    int horizontalPosition;
    int verticalPosition;
    private IFormatEngine formatEngine;
    private ICompositor compositor;
    private IBook book;
    private List<IDrawable> lines;
    private FontRenderContext fontRC;
    private Graphics2D paperGraphics;

    public JGraphicDriver() {
        this.setPreferredSize(new Dimension(256, 256));
    }

    static int pixelToDimension(float px) {
        return Math.round(px * 100.0f);
    }

    static float dimensionToPixel(int dim) {
        return (float)dim * 1.0f / 100.0f;
    }

    public void setCompositor(ICompositor compositor) {
        this.compositor = compositor;
    }

    public void setFormatEngine(IFormatEngine engine) {
        this.formatEngine = engine;
    }

    public void setBook(IBook book) {
        this.book = book;
        this.lines = null;
        this.clear();
    }

    Graphics2D getPaperGraphics() {
        return this.paperGraphics;
    }

    FontRenderContext getFontRC() {
        return this.fontRC;
    }

    @Override
    public void addHorizontalSpace(int amount) {
        this.horizontalPosition += amount;
    }

    @Override
    public void addVerticalSpace(int amount) {
        this.verticalPosition += amount;
    }

    @Override
    public void clear() {
        this.verticalPosition = 0;
        this.horizontalPosition = 0;
    }

    @Override
    public AWTFontAdapter getFont(String name, int size) {
        return new AWTFontAdapter(name, size, this.fontRC);
    }

    @Override
    public int getHorizontalPosition() {
        return this.horizontalPosition;
    }

    @Override
    public int getVerticalPosition() {
        return this.verticalPosition;
    }

    @Override
    public IDrawable renderBox(int width, int height, int depth) {
        throw new UnsupportedOperationException("boxes aren't supported");
    }

    @Override
    public IDrawable renderString(String s, IFont font) {
        if (this.fontRC == null) {
            throw new IllegalStateException("renderString with null frc");
        }
        return new SwingString(this, s, font);
    }

    @Override
    public IDrawable renderImage(InputStream dataStream) throws IOException {
        BufferedImage image = ImageIO.read(dataStream);
        return new AWTImageAdapter(this, image);
    }

    @Override
    public int getPaperWidth() {
        Insets insets = this.getInsets();
        return JGraphicDriver.pixelToDimension(this.getWidth() - insets.left - insets.right);
    }

    @Override
    public int getPaperHeight() {
        Insets insets = this.getInsets();
        return JGraphicDriver.pixelToDimension(this.getHeight() - insets.top - insets.bottom);
    }

    @Override
    protected void paintComponent(Graphics g) {
        System.err.println("REPAINT " + this.getWidth() + "x" + this.getHeight());
        if (this.isOpaque()) {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        if (this.book == null) {
            return;
        }
        Insets insets = this.getInsets();
        int w = this.getWidth() - insets.left - insets.right;
        int h = this.getHeight() - insets.top - insets.bottom;
        System.out.println(w + "x" + h);
        this.paperGraphics = (Graphics2D)g.create(insets.left, insets.top, w, h);
        this.paperGraphics.setBackground(this.getBackground());
        this.paperGraphics.setColor(Color.BLACK);
        this.fontRC = this.paperGraphics.getFontRenderContext();
        if (this.lines == null || this.getPaperWidth() != this.lines.get(0).getWidth(Position.MIDDLE_OF_LINE)) {
            System.err.println("formatting");
            this.lines = this.formatEngine.format(this, this.compositor, this.book.getFirstBody());
            System.err.println("done");
            int height = 0;
            for (IDrawable dr : this.lines) {
                height += dr.getHeight() + dr.getDepth();
            }
            this.setPreferredSize(new Dimension(this.getWidth(), Math.round(JGraphicDriver.dimensionToPixel(height + insets.top + insets.bottom))));
            this.revalidate();
            this.repaint();
        } else {
            int hmin = 0;
            int hmax = this.getPaperHeight();
            Rectangle rectangle = this.paperGraphics.getClipBounds();
            if (rectangle != null) {
                hmin = JGraphicDriver.pixelToDimension(rectangle.y);
                hmax = JGraphicDriver.pixelToDimension(rectangle.y + rectangle.height);
            }
            System.out.print("rendering ");
            this.verticalPosition = 0;
            this.horizontalPosition = 0;
            for (IDrawable dr : this.lines) {
                if (this.verticalPosition + dr.getHeight() > hmin) {
                    dr.draw(Position.MIDDLE_OF_LINE);
                    this.horizontalPosition = 0;
                }
                this.verticalPosition += dr.getHeight() + dr.getDepth();
                if (this.verticalPosition <= hmax) continue;
                break;
            }
            System.out.println("done");
        }
        this.fontRC = null;
        this.paperGraphics.dispose();
        this.paperGraphics = null;
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return true;
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 10;
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 100;
    }
}

