/*
 * Decompiled with CFR 0.152.
 */
package jbookreader.formatengine;

import java.util.ArrayList;
import java.util.List;
import jbookreader.formatengine.HBox;
import jbookreader.formatengine.ICompositor;
import jbookreader.formatengine.SimpleWhitespace;
import jbookreader.rendering.IDrawable;
import jbookreader.rendering.IGraphicDriver;
import jbookreader.rendering.Position;
import jbookreader.style.Alignment;

public class SimpleCompositor
implements ICompositor {
    private Alignment alignment = Alignment.LEFT;

    @Override
    public List<IDrawable> compose(List<IDrawable> particles, int width, IGraphicDriver driver) {
        ArrayList<IDrawable> result = new ArrayList<IDrawable>();
        HBox hbox = new HBox();
        for (IDrawable d : particles) {
            int width_add = hbox.calculateWidthAddition(-1, d);
            if (hbox.getWidth(Position.MIDDLE_OF_LINE) + width_add > width) {
                result.add(this.fixHBox(width, driver, hbox));
                hbox = new HBox();
            }
            hbox.add(d);
        }
        if (!hbox.isEmpty()) {
            result.add(this.fixHBox(width, driver, hbox));
        }
        return result;
    }

    private HBox fixHBox(int width, IGraphicDriver driver, HBox hbox) {
        int defect = width - hbox.getWidth(Position.MIDDLE_OF_LINE);
        if (defect == 0) {
            return hbox;
        }
        HBox wrapperBox = new HBox();
        switch (this.alignment) {
            case LEFT: {
                wrapperBox.add(hbox);
                wrapperBox.add(new SimpleWhitespace(driver, defect));
                break;
            }
            case RIGHT: {
                wrapperBox.add(new SimpleWhitespace(driver, defect));
                wrapperBox.add(hbox);
                break;
            }
            case CENTER: {
                wrapperBox.add(new SimpleWhitespace(driver, defect / 2));
                wrapperBox.add(hbox);
                wrapperBox.add(new SimpleWhitespace(driver, (defect + 1) / 2));
            }
        }
        return wrapperBox;
    }
}

