/*
 * Decompiled with CFR 0.152.
 */
package jbookreader.formatengine;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import jbookreader.rendering.IDrawable;
import jbookreader.rendering.Position;

class HBox
implements IDrawable {
    private final List<IDrawable> elements = new ArrayList<IDrawable>();
    private int width;
    private int height;
    private int depth;
    private int stretch;
    private int shrink;

    HBox() {
    }

    @Override
    public void draw(Position position) {
        ListIterator<IDrawable> it = this.elements.listIterator();
        while (it.hasNext()) {
            IDrawable drawable = it.next();
            if (it.previousIndex() == 0) {
                drawable.draw(Position.START_OF_LINE);
                continue;
            }
            if (it.hasNext()) {
                drawable.draw(Position.MIDDLE_OF_LINE);
                continue;
            }
            drawable.draw(Position.END_OF_LINE);
        }
    }

    @Override
    public int getDepth() {
        return this.depth;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public int getWidth(Position position) {
        return this.width;
    }

    @Override
    public int getShrink() {
        return this.shrink;
    }

    @Override
    public int getStretch() {
        return this.stretch;
    }

    public int calculateWidthAddition(int index, IDrawable drawable) {
        if (index == -1) {
            index = this.elements.size();
        }
        if (this.elements.isEmpty()) {
            return drawable.getWidth(Position.START_OF_LINE);
        }
        if (index == 0) {
            IDrawable first = this.elements.get(0);
            return drawable.getWidth(Position.START_OF_LINE) + first.getWidth(Position.MIDDLE_OF_LINE) - first.getWidth(Position.START_OF_LINE);
        }
        if (index == this.elements.size()) {
            IDrawable last = this.elements.get(this.elements.size() - 1);
            return drawable.getWidth(Position.END_OF_LINE) + last.getWidth(Position.MIDDLE_OF_LINE) - last.getWidth(Position.END_OF_LINE);
        }
        return drawable.getWidth(Position.MIDDLE_OF_LINE);
    }

    public void add(int index, IDrawable drawable) {
        this.width += this.calculateWidthAddition(index, drawable);
        this.addDimensions(drawable);
        this.elements.add(index, drawable);
    }

    private void addDimensions(IDrawable drawable) {
        this.stretch += drawable.getStretch();
        this.shrink += drawable.getShrink();
        if (this.height < drawable.getHeight()) {
            this.height = drawable.getHeight();
        }
        if (this.depth < drawable.getDepth()) {
            this.depth = drawable.getDepth();
        }
    }

    public void add(IDrawable drawable) {
        this.add(this.elements.size(), drawable);
    }

    public void addAll(List<IDrawable> drawables) {
        ListIterator<IDrawable> it = drawables.listIterator();
        while (it.hasNext()) {
            IDrawable drawable = it.next();
            this.width = it.previousIndex() == 0 && this.elements.size() == 0 ? (this.width += drawable.getWidth(Position.START_OF_LINE)) : (it.hasNext() ? (this.width += drawable.getWidth(Position.MIDDLE_OF_LINE)) : (this.width += drawable.getWidth(Position.END_OF_LINE)));
            this.addDimensions(drawable);
            this.elements.add(drawable);
        }
    }

    public boolean isEmpty() {
        return this.elements.isEmpty();
    }
}

