/*
 * Decompiled with CFR 0.152.
 */
package jbookreader.formatengine;

import jbookreader.rendering.IDrawable;
import jbookreader.rendering.IGraphicDriver;
import jbookreader.rendering.Position;

class Glue
implements IDrawable {
    private final int space;
    private final int stretch;
    private final int shrink;
    private final IGraphicDriver driver;

    Glue(IGraphicDriver driver, int space, int stretch, int shrink) {
        this.driver = driver;
        this.space = space;
        this.stretch = stretch;
        this.shrink = shrink;
    }

    @Override
    public int getShrink() {
        return this.shrink;
    }

    @Override
    public int getWidth(Position position) {
        if (position != Position.MIDDLE_OF_LINE) {
            return 0;
        }
        return this.space;
    }

    @Override
    public int getStretch() {
        return this.stretch;
    }

    @Override
    public int getDepth() {
        return 0;
    }

    @Override
    public int getHeight() {
        return 0;
    }

    @Override
    public void draw(Position position) {
        if (position == Position.MIDDLE_OF_LINE) {
            this.driver.addHorizontalSpace(this.space);
        }
    }

    public String toString() {
        return "Glue: " + this.space + ":" + this.stretch + ":" + this.shrink;
    }
}

