/*
 * Decompiled with CFR 0.152.
 */
package jbookreader.ui.text;

import java.util.List;
import jbookreader.book.IBook;
import jbookreader.fileformats.IErrorHandler;
import jbookreader.fileformats.impl.FictionBook2;
import jbookreader.formatengine.FormatEngine;
import jbookreader.formatengine.SimpleCompositor;
import jbookreader.rendering.IDrawable;
import jbookreader.rendering.Position;
import jbookreader.rendering.text.TextRenderer;
import jbookreader.util.BookFactoryCreator;

public class Main {
    public static void main(String[] args) throws Exception {
        IErrorHandler handler = new IErrorHandler(){

            @Override
            public boolean error(boolean fatal, String message) {
                System.err.println(message);
                return true;
            }

            @Override
            public void warning(String message) {
                System.err.println(message);
            }
        };
        IBook book = new FictionBook2().parse(args.length > 0 ? args[0] : "tests/simple.fb2", handler, BookFactoryCreator.getBookFactory());
        System.err.println("parsed");
        TextRenderer driver = new TextRenderer();
        SimpleCompositor compositor = new SimpleCompositor();
        FormatEngine engine = new FormatEngine();
        List<IDrawable> lines = engine.format(driver, compositor, book.getFirstBody());
        System.err.println("formatted");
        for (IDrawable dr : lines) {
            dr.draw(Position.MIDDLE_OF_LINE);
            driver.clear();
            System.out.println();
        }
    }
}

