/*
 * Decompiled with CFR 0.152.
 */
package jbookreader.fileformats.impl;

import jbookreader.fileformats.IErrorHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class SAXParseErrorHandler
implements ErrorHandler {
    private final IErrorHandler handler;

    public SAXParseErrorHandler(IErrorHandler handler) {
        this.handler = handler;
    }

    private String generateMessage(SAXParseException exception) {
        return exception.getSystemId() + ":" + exception.getLineNumber() + ": " + exception.getLocalizedMessage();
    }

    @Override
    public void error(SAXParseException exception) throws SAXException {
        if (this.handler.error(false, this.generateMessage(exception))) {
            throw exception;
        }
        exception.printStackTrace();
    }

    @Override
    public void fatalError(SAXParseException exception) throws SAXException {
        this.handler.error(true, this.generateMessage(exception));
        throw exception;
    }

    @Override
    public void warning(SAXParseException exception) throws SAXException {
        this.handler.warning(this.generateMessage(exception));
        exception.printStackTrace();
    }
}

