/*
 * Decompiled with CFR 0.152.
 */
package org.jbookreader.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectoryLoader
extends ClassLoader {
    private byte[] readFile(File file) throws IOException {
        BufferedInputStream input = new BufferedInputStream(new FileInputStream(file));
        ArrayList<Buffer> blist = new ArrayList<Buffer>();
        int totalLength = 0;
        while (true) {
            Buffer b = new Buffer();
            b.array = new byte[1024];
            b.length = ((InputStream)input).read(b.array);
            if (b.length <= 0) break;
            blist.add(b);
            totalLength += b.length;
        }
        byte[] result = new byte[totalLength];
        int offset = 0;
        for (Buffer b : blist) {
            for (int i = 0; i < b.length; ++i) {
                result[offset++] = b.array[i];
            }
        }
        return result;
    }

    public Class<?>[] loadClasses(File directory) throws IOException {
        File[] classFiles = directory.listFiles(new ClassNameFilter());
        Class[] classes = new Class[classFiles.length];
        int i = 0;
        for (File f : classFiles) {
            byte[] data = this.readFile(f);
            Class<?> fclass = this.defineClass(null, data, 0, data.length);
            this.resolveClass(fclass);
            classes[i++] = fclass;
        }
        return classes;
    }

    private static class ClassNameFilter
    implements FilenameFilter {
        private ClassNameFilter() {
        }

        public boolean accept(File dir, String name) {
            return name.endsWith(".class");
        }
    }

    private static class Buffer {
        byte[] array;
        int length;

        private Buffer() {
        }
    }
}

