/*
 * Decompiled with CFR 0.152.
 */
package org.jbookreader.ui.swing.painter;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import javax.swing.JComponent;
import org.jbookreader.book.bom.IBook;
import org.jbookreader.formatengine.impl.FormatEngine;
import org.jbookreader.renderingengine.RenderingEngine;
import org.jbookreader.ui.swing.painter.SwingBookPainter;

public class JBookComponent
extends JComponent {
    private static final long serialVersionUID = -2480969864889318912L;
    private final SwingBookPainter myPainter;
    private final RenderingEngine myEngine = new RenderingEngine(new FormatEngine());
    private IBook myBook;
    private boolean myAntialias;
    private int myDefaultFontSize;

    public JBookComponent() {
        this.myPainter = new SwingBookPainter();
        this.myEngine.setPainter(this.myPainter);
    }

    public boolean isOpaque() {
        return true;
    }

    private int getPageHeight() {
        Insets insets = this.getInsets();
        return this.getHeight() - insets.top - insets.bottom;
    }

    protected void paintComponent(Graphics g) {
        if (this.isOpaque()) {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        Insets insets = this.getInsets();
        int w = this.getWidth() - insets.left - insets.right;
        int h = this.getPageHeight();
        Graphics2D g2d = (Graphics2D)g.create(insets.left, insets.top, w, h);
        g2d.setBackground(this.getBackground());
        if (this.myPainter.getWidth() != (double)w) {
            this.myEngine.flush();
        }
        if (this.myAntialias) {
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        this.myPainter.setGraphics(g2d, w, h);
        if (this.myBook != null) {
            this.myEngine.renderPage();
        }
        g2d.dispose();
    }

    public void setBook(IBook book) {
        this.myBook = book;
        this.myEngine.setBook(this.myBook);
        this.repaint();
    }

    public void scrollPageDown() {
        this.myEngine.scroll(this.getPageHeight() - this.myDefaultFontSize * 2);
        this.repaint();
    }

    public void scrollPageUp() {
        this.myEngine.scroll(-(this.getPageHeight() - this.myDefaultFontSize * 2));
        this.repaint();
    }

    public void scrollDown(int pixels) {
        this.myEngine.scroll(pixels);
        this.repaint();
    }

    public void scrollUp(int pixels) {
        this.myEngine.scroll(-pixels);
        this.repaint();
    }

    public void setDefaultFont(String family, int size) {
        this.myDefaultFontSize = size;
        this.myEngine.setDefaultFont(family, size);
        this.myEngine.flush();
        this.repaint();
    }

    public boolean isAntialias() {
        return this.myAntialias;
    }

    public void setAntialias(boolean antialias) {
        this.myAntialias = antialias;
    }

    public String getDisplayNodeReference() {
        return this.myEngine.getDisplayNodeReference();
    }

    public void setBookPositionByReference(String reference) {
        this.myEngine.scrollToReference(reference);
    }
}

