/*
 * Decompiled with CFR 0.152.
 */
package org.jbookreader.ui.swing.painter;

import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import org.jbookreader.book.bom.INode;
import org.jbookreader.formatengine.objects.AbstractInlineRenderingObject;
import org.jbookreader.ui.swing.painter.SwingBookPainter;

class ImageRenderingObject
extends AbstractInlineRenderingObject {
    private final BufferedImage myImage;

    public ImageRenderingObject(SwingBookPainter painter, INode node, InputStream stream) throws IOException {
        super(painter, node);
        this.myImage = ImageIO.read(stream);
        if (this.myImage == null) {
            throw new RuntimeException("Can't load image");
        }
        this.setHeight(this.myImage.getHeight());
        this.setWidth(this.myImage.getWidth());
    }

    public void renderInline() {
        SwingBookPainter painter = (SwingBookPainter)this.getPainter();
        painter.getGraphics().drawImage(this.myImage, new AffineTransform(1.0, 0.0, 0.0, 1.0, this.getPainter().getXCoordinate(), this.getPainter().getYCoordinate() - this.getHeight()), null);
        this.getPainter().addHorizontalStrut(this.getWidth());
    }

    public boolean isSplittable() {
        return true;
    }
}

