/*
 * Decompiled with CFR 0.152.
 */
package org.jbookreader.ui.swing.actions;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JFileChooser;
import org.jbookreader.ui.swing.Config;
import org.jbookreader.ui.swing.GenericFileFilter;
import org.jbookreader.ui.swing.MainWindow;
import org.jbookreader.ui.swing.Messages;

public class OpenAction
extends AbstractAction {
    private File myLastDirectory = null;
    private static Action ourAction;

    private OpenAction() {
        this.putValue("Name", Messages.getString("OpenAction.Name"));
        this.putValue("MnemonicKey", Messages.getString("OpenAction.Mnemonic").charAt(0));
        this.putValue("ShortDescription", Messages.getString("OpenAction.Description"));
        String dir = Config.getConfig().getStringValue("lastdir");
        if (dir == null) {
            dir = System.getProperty("user.dir");
        }
        this.myLastDirectory = new File(dir);
    }

    public static Action getAction() {
        if (ourAction == null) {
            ourAction = new OpenAction();
        }
        return ourAction;
    }

    public void actionPerformed(ActionEvent e) {
        JFileChooser chooser = new JFileChooser();
        GenericFileFilter filter = new GenericFileFilter();
        filter.addExtension("fb2");
        filter.addExtension("fb2.zip");
        filter.setDescription(Messages.getString("FB2Description"));
        chooser.setFileFilter(filter);
        chooser.setCurrentDirectory(this.myLastDirectory);
        int returnValue = chooser.showOpenDialog(MainWindow.getMainWindow().getFrame());
        this.myLastDirectory = chooser.getCurrentDirectory();
        Config.getConfig().setStringValue("lastdir", this.myLastDirectory.getAbsolutePath());
        try {
            Config.getConfig().save();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        if (returnValue == 0) {
            MainWindow.getMainWindow().openBook(chooser.getSelectedFile());
        }
    }
}

