/*
 * Decompiled with CFR 0.152.
 */
package org.jbookreader.ui.swing;

import java.awt.Container;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import org.jbookreader.ui.swing.Config;
import org.jbookreader.ui.swing.MainWindow;

public class OptionsDialog {
    private static OptionsDialog ourOptionsDialog;
    private final JDialog myDialog = new JDialog(MainWindow.getMainWindow().getFrame());
    private JCheckBox myAntialias;
    private JTextField myFontFamily;
    private JSpinner myFontSize;

    private OptionsDialog() {
        this.myDialog.setTitle("Options");
        this.myDialog.setModal(true);
        this.myDialog.setDefaultCloseOperation(1);
        this.myDialog.addComponentListener(new OptionsComponentListener());
        Container pane = this.myDialog.getContentPane();
        pane.setLayout(new GridLayout(4, 2));
        pane.add(new JLabel());
        this.myAntialias = new JCheckBox("Antialias text");
        pane.add(this.myAntialias);
        pane.add(new JLabel("Font Family", 0));
        this.myFontFamily = new JTextField(15);
        pane.add(this.myFontFamily);
        pane.add(new JLabel("Font Size", 0));
        this.myFontSize = new JSpinner();
        pane.add(this.myFontSize);
        pane.add(new JButton(new OKAction()));
        pane.add(new JButton(new CancelAction()));
        this.myDialog.pack();
    }

    public static OptionsDialog getOptionsDialog() {
        if (ourOptionsDialog == null) {
            ourOptionsDialog = new OptionsDialog();
        }
        return ourOptionsDialog;
    }

    public JDialog getDialog() {
        return this.myDialog;
    }

    private void fillValues() {
        this.myAntialias.setSelected(Config.getConfig().getBooleanValue("antialias"));
        this.myFontFamily.setText(Config.getConfig().getStringValue("fontfamily"));
        this.myFontSize.setValue(Config.getConfig().getIntValue("fontsize"));
    }

    public void commitValues() {
        boolean antialias = this.myAntialias.isSelected();
        Config.getConfig().setBooleanValue("antialias", antialias);
        String family = this.myFontFamily.getText();
        Config.getConfig().setStringValue("fontfamily", family);
        int size = (Integer)this.myFontSize.getValue();
        Config.getConfig().setIntValue("fontsize", size);
        MainWindow.getMainWindow().getBookComponent().setAntialias(antialias);
        MainWindow.getMainWindow().getBookComponent().setDefaultFont(family, size);
        MainWindow.getMainWindow().getBookComponent().repaint();
        try {
            Config.getConfig().save();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.getDialog().setVisible(false);
    }

    private class CancelAction
    extends AbstractAction {
        public CancelAction() {
            this.putValue("Name", "Cancel");
            this.putValue("MnemonicKey", 67);
        }

        public void actionPerformed(ActionEvent e) {
            OptionsDialog.this.getDialog().setVisible(false);
        }
    }

    private class OKAction
    extends AbstractAction {
        public OKAction() {
            this.putValue("Name", "OK");
            this.putValue("MnemonicKey", 79);
        }

        public void actionPerformed(ActionEvent e) {
            OptionsDialog.this.commitValues();
        }
    }

    private class OptionsComponentListener
    extends ComponentAdapter {
        private OptionsComponentListener() {
        }

        public void componentShown(ComponentEvent e) {
            OptionsDialog.this.fillValues();
        }
    }
}

