/*
 * Decompiled with CFR 0.152.
 */
package org.jbookreader.renderingengine;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.WeakHashMap;
import org.jbookreader.book.bom.IBook;
import org.jbookreader.book.bom.IContainerNode;
import org.jbookreader.book.bom.INode;
import org.jbookreader.book.stylesheet.EDisplayType;
import org.jbookreader.book.stylesheet.IStyleStack;
import org.jbookreader.formatengine.IBookPainter;
import org.jbookreader.formatengine.IFormatEngine;
import org.jbookreader.formatengine.IRenderingObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RenderingEngine {
    private IBookPainter myPainter;
    private IBook myBook;
    private final IFormatEngine myFormatEngine;
    private String myFontFamily;
    private int myFontSize;
    private INode myStartNode;
    private int myStartRenderingObject;
    private double myStartY;
    private double myPageHeight;
    private Map<INode, List<IRenderingObject>> myFormattedNodes = new WeakHashMap<INode, List<IRenderingObject>>();

    public RenderingEngine(IFormatEngine formatEngine) {
        this.myFormatEngine = formatEngine;
    }

    public void setPainter(IBookPainter painter) {
        this.myPainter = painter;
        this.myPageHeight = painter.getHeight();
    }

    public void setBook(IBook book) {
        this.myBook = book;
        IContainerNode node = this.myBook.getMainBody();
        IStyleStack styleStack = this.replayStyleStack(node);
        this.myStartNode = this.getParagraphNodeDown(node, styleStack, true);
        this.myStartRenderingObject = 0;
        this.flush();
    }

    private INode getParagraphNode(INode node, IStyleStack styleStack, boolean next) {
        int nextindex;
        List<INode> children;
        while (true) {
            IContainerNode pnode = node.getParentNode();
            styleStack.popTag();
            if (pnode == null) {
                return null;
            }
            children = pnode.getChildNodes();
            int index = children.indexOf(node);
            nextindex = index + (next ? 1 : -1);
            if (index == -1) {
                throw new IllegalStateException("Node '" + node + "' not found in it's parent list!!!!");
            }
            if (nextindex < children.size() && nextindex >= 0) break;
            node = pnode;
        }
        node = children.get(nextindex);
        styleStack.pushTag(node.getTagName(), node.getNodeClass(), node.getID());
        return this.getParagraphNodeDown(node, styleStack, next);
    }

    private INode getParagraphNodeDown(INode node, IStyleStack styleStack, boolean first) {
        while (node instanceof IContainerNode) {
            IContainerNode cnode = (IContainerNode)node;
            List<INode> children = cnode.getChildNodes();
            if (children.isEmpty()) {
                return node;
            }
            int number = first ? 0 : children.size() - 1;
            INode child = children.get(number);
            styleStack.pushTag(child.getTagName(), child.getNodeClass(), child.getID());
            if (styleStack.getDisplay() == EDisplayType.INLINE) {
                styleStack.popTag();
                return node;
            }
            node = child;
        }
        return node;
    }

    private List<IRenderingObject> getFormattedNode(INode node, IStyleStack styleStack, double width) {
        List<IRenderingObject> robject = this.myFormattedNodes.get(node);
        if (robject == null) {
            robject = this.myFormatEngine.formatParagraphNode(this.myPainter, node, styleStack, width);
            this.myFormattedNodes.put(node, robject);
        }
        return robject;
    }

    private void fixupStartPosition() {
        block10: {
            IRenderingObject robject;
            INode node = this.myStartNode;
            IStyleStack styleStack = this.replayStyleStack(node);
            List<IRenderingObject> paragraph = this.getFormattedNode(node, styleStack, this.myPainter.getWidth());
            ListIterator<IRenderingObject> robjectIterator = paragraph.listIterator(this.myStartRenderingObject);
            if (this.myStartY < 0.0) {
                while (true) {
                    IRenderingObject robject2;
                    if (!robjectIterator.hasNext()) {
                        if ((node = this.getParagraphNode(node, styleStack, true)) == null) {
                            node = this.myStartNode;
                            styleStack = this.replayStyleStack(node);
                            this.myStartY = 0.0;
                            --this.myStartRenderingObject;
                            break block10;
                        }
                        paragraph = this.getFormattedNode(node, styleStack, this.myPainter.getWidth());
                        this.myStartRenderingObject = 0;
                        robjectIterator = paragraph.listIterator(this.myStartRenderingObject);
                        this.myStartNode = node;
                    }
                    if (this.myStartY + (robject2 = robjectIterator.next()).getHeight() >= 0.0) {
                        if (robject2.isSplittable() || this.myStartY == 0.0) break block10;
                        this.myStartY = 0.0;
                    } else {
                        this.myStartY += robject2.getHeight();
                    }
                    ++this.myStartRenderingObject;
                }
            }
            if (!(this.myStartY > 0.0)) break block10;
            do {
                if (!robjectIterator.hasPrevious()) {
                    if ((node = this.getParagraphNode(node, styleStack, false)) == null) {
                        node = this.myStartNode;
                        styleStack = this.replayStyleStack(node);
                        this.myStartY = 0.0;
                        this.myStartRenderingObject = 0;
                        break block10;
                    }
                    paragraph = this.getFormattedNode(node, styleStack, this.myPainter.getWidth());
                    this.myStartRenderingObject = paragraph.size();
                    robjectIterator = paragraph.listIterator(this.myStartRenderingObject);
                    this.myStartNode = node;
                }
                robject = robjectIterator.previous();
                this.myStartY -= robject.getHeight();
                --this.myStartRenderingObject;
            } while (!(this.myStartY <= 0.0));
            if (!robject.isSplittable()) {
                this.myStartY = 0.0;
            }
        }
    }

    public void renderPage() {
        this.myPainter.clear();
        if (this.myBook == null) {
            return;
        }
        this.myPageHeight = this.myPainter.getHeight();
        this.fixupStartPosition();
        INode node = this.myStartNode;
        IStyleStack styleStack = this.replayStyleStack(node);
        this.myPainter.addVerticalStrut(this.myStartY);
        int startObject = this.myStartRenderingObject;
        block0: while (node != null) {
            List<IRenderingObject> paragraph = this.getFormattedNode(node, styleStack, this.myPainter.getWidth());
            ListIterator<IRenderingObject> it = paragraph.listIterator(startObject);
            while (it.hasNext()) {
                IRenderingObject robject = it.next();
                double currentY = this.myPainter.getYCoordinate();
                if (currentY >= this.myPageHeight || !robject.isSplittable() && currentY + robject.getHeight() > this.myPageHeight) break block0;
                robject.render();
            }
            node = this.getParagraphNode(node, styleStack, true);
            startObject = 0;
        }
    }

    private IStyleStack replayStyleStack(INode node) {
        IStyleStack result = node.getBook().getSystemStyleSheet().newStyleStateStack();
        if (this.myFontFamily != null) {
            result.setDefaultFontFamily(this.myFontFamily);
        }
        if (this.myFontSize != 0) {
            result.setDefaultFontSize(this.myFontSize);
        }
        ArrayList<INode> backList = new ArrayList<INode>();
        while (node != null) {
            backList.add(node);
            node = node.getParentNode();
        }
        ListIterator iterator = backList.listIterator(backList.size());
        while (iterator.hasPrevious()) {
            INode current = (INode)iterator.previous();
            result.pushTag(current.getTagName(), current.getNodeClass(), current.getID());
        }
        return result;
    }

    public void scroll(int pixels) {
        this.myStartY -= (double)pixels;
    }

    public void setDefaultFont(String family, int size) {
        this.myFontFamily = family;
        this.myFontSize = size;
    }

    public void flush() {
        this.myFormattedNodes.clear();
        this.myStartY = 0.0;
    }

    public String getDisplayNodeReference() {
        if (this.myStartNode == null) {
            return null;
        }
        return this.myStartNode.getNodeReference();
    }

    public void scrollToReference(String reference) {
        INode node = this.myBook.getNodeByReference(reference);
        if (node == null) {
            System.err.println("Bad book reference passed: " + reference);
            return;
        }
        this.myStartNode = node;
        this.myStartRenderingObject = 0;
        this.flush();
    }
}

