/*
 * Decompiled with CFR 0.152.
 */
package org.jbookreader.formatengine.objects;

import org.jbookreader.book.bom.INode;
import org.jbookreader.formatengine.IBookPainter;
import org.jbookreader.formatengine.IFont;
import org.jbookreader.formatengine.RenderingDimensions;
import org.jbookreader.formatengine.objects.AbstractInlineRenderingObject;

public class MetaString
extends AbstractInlineRenderingObject {
    private final String myText;
    private final int myStart;
    private final int myEnd;
    private final IFont myFont;
    private final double myHalfLeading;

    public MetaString(IBookPainter painter, INode node, double lineHeight, String text, int start, int end, IFont font) {
        super(painter, node);
        this.myText = text;
        this.myStart = start;
        this.myEnd = end;
        this.myFont = font;
        RenderingDimensions dim = font.calculateStringDimensions(this.myText, start, end);
        double height = lineHeight * this.myFont.getFontSize();
        this.myHalfLeading = (height - dim.ascent) / 2.0;
        this.setHeight(height);
        this.setDepth(dim.depth + this.myHalfLeading);
        this.setWidth(dim.width);
    }

    public void renderInline() {
        this.myFont.renderString(this.myText, this.myStart, this.myEnd);
    }
}

