/*
 * Decompiled with CFR 0.152.
 */
package org.jbookreader.book.bom.impl;

import org.jbookreader.book.bom.IBinaryData;

class BinaryData
implements IBinaryData {
    private String myContentType;
    private byte[] myContentsArray = new byte[1];
    private int myContentsLength;

    BinaryData() {
    }

    public String getContentType() {
        return this.myContentType;
    }

    public void setContentType(String contentType) {
        this.myContentType = contentType;
    }

    private char getBase64Char(long bits) {
        if (bits < 0L || bits > 63L) {
            throw new IllegalArgumentException("Bad character number during encoding: " + bits);
        }
        if (bits < 26L) {
            return (char)(65L + bits);
        }
        if (bits < 52L) {
            return (char)(97L + bits - 26L);
        }
        if (bits < 62L) {
            return (char)(48L + bits - 52L);
        }
        if (bits == 62L) {
            return '+';
        }
        return '/';
    }

    public CharSequence getBase64Encoded() {
        StringBuilder result = new StringBuilder();
        int bitbuffer = 0;
        for (int i = 0; i < this.myContentsLength; ++i) {
            bitbuffer = bitbuffer << 8 | this.myContentsArray[i] & 0xFF;
            switch (i % 3) {
                case 0: {
                    result.append(this.getBase64Char(bitbuffer >>> 2 & 0x3F));
                    break;
                }
                case 1: {
                    result.append(this.getBase64Char(bitbuffer >>> 4 & 0x3F));
                    break;
                }
                case 2: {
                    result.append(this.getBase64Char(bitbuffer >>> 6 & 0x3F));
                    result.append(this.getBase64Char(bitbuffer >>> 0 & 0x3F));
                }
            }
            if ((i + 1) % 54 != 0) continue;
            result.append("\n");
        }
        if (this.myContentsLength % 3 == 1) {
            result.append(this.getBase64Char((bitbuffer <<= 8) >>> 4 & 0x3F));
            result.append("==");
        } else if (this.myContentsLength % 3 == 2) {
            result.append(this.getBase64Char((bitbuffer <<= 8) >>> 6 & 0x3F));
            result.append("=");
        }
        if (this.myContentsLength % 54 != 0) {
            result.append("\n");
        }
        return result;
    }

    public void setBase64Encoded(char[] base64Encoded) {
        this.myContentsArray = new byte[base64Encoded.length / 4 * 3];
        this.myContentsLength = 0;
        int bitBuffer = 0;
        int bitBufferBytes = 0;
        int byteBufferPad = 0;
        for (char curch : base64Encoded) {
            if (curch == '\n' || curch == '\r' || curch == ' ' || curch == '\t') continue;
            bitBuffer <<= 6;
            if (curch >= 'A' && curch <= 'Z') {
                bitBuffer += curch - 65;
            } else if (curch >= 'a' && curch <= 'z') {
                bitBuffer += curch - 97 + 26;
            } else if (curch >= '0' && curch <= '9') {
                bitBuffer += curch - 48 + 52;
            } else if (curch == '+') {
                bitBuffer += 62;
            } else if (curch == '/') {
                bitBuffer += 63;
            } else if (curch == '=') {
                ++byteBufferPad;
            } else {
                throw new IllegalArgumentException("Bad character value: '" + curch + "'");
            }
            if (++bitBufferBytes != 4) continue;
            this.myContentsArray[this.myContentsLength++] = (byte)(bitBuffer >> 16);
            if (byteBufferPad < 2) {
                this.myContentsArray[this.myContentsLength++] = (byte)(bitBuffer >> 8);
            }
            if (byteBufferPad < 1) {
                this.myContentsArray[this.myContentsLength++] = (byte)(bitBuffer >> 0);
            }
            bitBufferBytes = 0;
            bitBuffer = 0;
        }
    }

    public void setContents(byte[] contents, int length) {
        if (this.myContentsLength < length) {
            this.myContentsArray = new byte[length];
        }
        this.myContentsLength = length;
        for (int i = 0; i < length; ++i) {
            this.myContentsArray[i] = contents[i];
        }
    }

    public byte[] getContentsArray() {
        return this.myContentsArray;
    }

    public int getContentsLength() {
        return this.myContentsLength;
    }
}

