/*
 * Decompiled with CFR 0.152.
 */
package org.jbookreader.formatengine.model;

import org.jbookreader.formatengine.IFont;
import org.jbookreader.formatengine.IRenderingObject;
import org.jbookreader.formatengine.RenderingDimensions;

public class MetaString
implements IRenderingObject {
    private final String myText;
    private final int myStart;
    private final int myEnd;
    private final IFont myFont;
    private final RenderingDimensions myDimensions;

    public MetaString(String text, int start, int end, IFont font) {
        this.myText = text;
        this.myStart = start;
        this.myEnd = end;
        this.myFont = font;
        this.myDimensions = font.calculateStringDimensions(this.myText, start, end);
    }

    public RenderingDimensions getDimensions() {
        return this.myDimensions;
    }

    public void render() {
        this.myFont.renderString(this.myText, this.myStart, this.myEnd, this.myDimensions);
    }

    public boolean isGlue() {
        return false;
    }
}

