/*
 * Decompiled with CFR 0.152.
 */
package org.jbookreader.util;

import java.io.InputStream;
import java.io.PrintWriter;
import org.jbookreader.book.bom.INode;
import org.jbookreader.formatengine.IBookPainter;
import org.jbookreader.formatengine.IFont;
import org.jbookreader.formatengine.IInlineRenderingObject;
import org.jbookreader.formatengine.RenderingDimensions;

public class TextPainter
implements IBookPainter {
    private static final double EMULATED_FONT_SIZE = 12.0;
    private static final double EMULATED_LINE_SKIP = 2.4000000000000004;
    private final PrintWriter myOutput;
    private int myX;
    private double myWidth;
    private double myRealX;
    private double myIntY;
    private double myRealY;
    private IFont myFont;

    public TextPainter(PrintWriter output, int width) {
        this.myOutput = output;
        this.myWidth = width;
    }

    public void clear() {
        this.myX = 0;
        this.myRealX = 0.0;
        this.myIntY = 0.0;
        this.myRealY = 0.0;
    }

    public double getWidth() {
        return this.myWidth;
    }

    public double getHeight() {
        return Double.POSITIVE_INFINITY;
    }

    public void addHorizontalStrut(double size) {
        this.myRealX += size;
    }

    public void addVerticalStrut(double size) {
        this.myRealY += size;
        while (this.myRealY >= 7.2) {
            this.myRealY -= 14.4;
            this.myIntY += 1.0;
            this.myOutput.println();
            this.myX = 0;
        }
    }

    public void close() {
        this.myOutput.close();
    }

    public IFont getFont(String name, int size) {
        if (this.myFont == null) {
            this.myFont = new IFont(){

                public double getSpaceWidth() {
                    return 1.0;
                }

                public RenderingDimensions calculateStringDimensions(String s, int start, int end) {
                    return new RenderingDimensions(12.0, 0.0, end - start);
                }

                public void renderString(String s, int start, int end) {
                    TextPainter.this.renderString(s, start, end);
                }

                public String getFontFamily() {
                    return "default";
                }

                public double getFontSize() {
                    return 12.0;
                }
            };
        }
        return this.myFont;
    }

    void renderString(String s, int start, int end) {
        while ((double)this.myX < this.myRealX - 0.5) {
            this.myOutput.append(' ');
            ++this.myX;
        }
        this.myOutput.append(s, start, end);
        this.myX += end - start;
        this.myRealX += (double)(end - start);
    }

    public double getXCoordinate() {
        return this.myX;
    }

    public double getYCoordinate() {
        return this.myRealY + this.myIntY * 14.4;
    }

    public IInlineRenderingObject getImage(INode node, String contentType, InputStream stream) {
        return null;
    }
}

