/*
 * Decompiled with CFR 0.152.
 */
package org.jbookreader.util;

import java.io.PrintWriter;
import java.util.Map;
import org.jbookreader.book.bom.IBinaryData;
import org.jbookreader.book.bom.IBook;
import org.jbookreader.book.bom.IContainerNode;
import org.jbookreader.book.bom.IImageNode;
import org.jbookreader.book.bom.INode;

public class ModelDumper {
    private static final String TEXT_NODE_NAME = "#text";

    private static void printNode(PrintWriter writer, INode node) {
        if (node == null) {
            return;
        }
        if (node.getTagName().equals(TEXT_NODE_NAME)) {
            writer.print(node.getText());
            return;
        }
        writer.print('<');
        writer.print(node.getTagName());
        String id = node.getID();
        if (id != null) {
            writer.printf(" id=\"%s\"", id);
        }
        if (node instanceof IImageNode) {
            IImageNode image = (IImageNode)node;
            writer.format(" xlink:href=\"%s\"", image.getHyperRef());
            if (image.getText() != null) {
                writer.format(" alt=\"%s\"", image.getText());
            }
            if (image.getTitle() != null) {
                writer.format(" title=\"%s\"", image.getTitle());
            }
        }
        if (node.getNodeClass() != null) {
            String nodeClass = node.getNodeClass();
            String tag = node.getTagName();
            String classAttribute = "class";
            if (tag.equals("p")) {
                classAttribute = "style";
            } else if (tag.equals("style")) {
                classAttribute = "name";
            }
            writer.format(" %s=\"%s\"", classAttribute, nodeClass);
        }
        IContainerNode cnode = null;
        if (node instanceof IContainerNode) {
            cnode = (IContainerNode)node;
        }
        if (cnode == null || cnode.getChildNodes().isEmpty()) {
            writer.print(" />");
            return;
        }
        writer.println('>');
        for (INode child : cnode.getChildNodes()) {
            ModelDumper.printNode(writer, child);
        }
        writer.println();
        writer.print("</");
        writer.print(node.getTagName());
        writer.print('>');
    }

    public static void dumpBOM(PrintWriter writer, IBook book) {
        writer.println("<FictionBook xmlns=\"http://www.gribuser.ru/xml/fictionbook/2.0\" xmlns:xlink=\"http://www.w3.org/1999/xlink\">");
        for (IContainerNode iContainerNode : book.getBodies()) {
            ModelDumper.printNode(writer, iContainerNode);
        }
        writer.println();
        for (Map.Entry entry : book.getBinaryMap().entrySet()) {
            writer.format("<binary id=\"%s\" content-type=\"%s\">%n", entry.getKey(), ((IBinaryData)entry.getValue()).getContentType());
            writer.append(((IBinaryData)entry.getValue()).getBase64Encoded());
            writer.println("</binary>");
        }
        writer.print("</FictionBook>");
    }
}

