/*
 * Decompiled with CFR 0.152.
 */
package org.jbookreader.ui.swing.painter;

import java.awt.Color;
import java.awt.Graphics2D;
import java.io.InputStream;
import org.jbookreader.book.bom.INode;
import org.jbookreader.formatengine.IBookPainter;
import org.jbookreader.formatengine.IFont;
import org.jbookreader.formatengine.IInlineRenderingObject;
import org.jbookreader.ui.swing.painter.ImageRenderingObject;
import org.jbookreader.ui.swing.painter.SwingFont;

public class SwingBookPainter
implements IBookPainter {
    private double myWidth;
    private double myHeight;
    private Graphics2D myGraphics;
    private double myCurrentX;
    private double myCurrentY;

    public void setGraphics(Graphics2D g2d, double width, double height) {
        this.myGraphics = g2d;
        this.myWidth = width;
        this.myHeight = height;
        this.myCurrentY = 0.0;
        this.myCurrentX = 0.0;
    }

    public void clear() {
        this.myGraphics.setColor(this.myGraphics.getBackground());
        this.myGraphics.fill(this.myGraphics.getClip());
        this.myGraphics.setColor(Color.BLACK);
        this.myCurrentY = 0.0;
        this.myCurrentX = 0.0;
    }

    public double getHeight() {
        return this.myHeight;
    }

    public double getWidth() {
        return this.myWidth;
    }

    public void addHorizontalStrut(double size) {
        this.myCurrentX += size;
    }

    public void addVerticalStrut(double size) {
        this.myCurrentY += size;
    }

    public IFont getFont(String name, int size) {
        return new SwingFont(this, name, size);
    }

    public double getXCoordinate() {
        return this.myCurrentX;
    }

    public double getYCoordinate() {
        return this.myCurrentY;
    }

    public IInlineRenderingObject getImage(INode node, String contentType, InputStream stream) {
        try {
            return new ImageRenderingObject(this, node, stream);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    Graphics2D getGraphics() {
        return this.myGraphics;
    }
}

