/*
 * Decompiled with CFR 0.152.
 */
package org.jbookreader.ui.swing;

import java.io.File;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.jbookreader.ui.swing.Config;
import org.jbookreader.ui.swing.MainWindow;

public class Main {
    public static void createAndShowGUI() {
        if (Config.getConfig().getBooleanValue("windows_decorated")) {
            JFrame.setDefaultLookAndFeelDecorated(true);
            JDialog.setDefaultLookAndFeelDecorated(true);
        }
        MainWindow main = MainWindow.getMainWindow();
        main.getBookComponent().setAntialias(Config.getConfig().getBooleanValue("antialias"));
        main.getBookComponent().setDefaultFont(Config.getConfig().getStringValue("fontfamily"), Config.getConfig().getIntValue("fontsize"));
        main.getFrame().setVisible(true);
    }

    public static void main(String[] args) {
        final String bookname = args.length > 0 ? args[0] : null;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Main.createAndShowGUI();
                if (bookname != null) {
                    MainWindow.getMainWindow().openBook(new File(bookname));
                } else {
                    String url = Config.getConfig().getStringValue("book_url");
                    String position = Config.getConfig().getStringValue("book_position");
                    if (url != null) {
                        MainWindow.getMainWindow().openBook(new File(url));
                    }
                    if (position != null && !position.equals("")) {
                        MainWindow.getMainWindow().getBookComponent().setBookPositionByReference(position);
                    }
                }
            }
        });
    }
}

