/*
 * Decompiled with CFR 0.152.
 */
package org.jbookreader.book.parser;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.jbookreader.book.bom.IBinaryData;
import org.jbookreader.book.bom.IBook;
import org.jbookreader.book.bom.IContainerNode;
import org.jbookreader.book.bom.IImageNode;
import org.jbookreader.book.bom.INode;
import org.jbookreader.book.bom.impl.Book;
import org.jbookreader.book.parser.ParseErrorHandler;
import org.jbookreader.book.stylesheet.IStyleSheet;
import org.jbookreader.book.stylesheet.fb2.FB2StyleSheet;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class FB2Parser {
    public static final String FB2_XMLNS_URI = "http://www.gribuser.ru/xml/fictionbook/2.0";
    private static IStyleSheet ssheet;

    public static IBook parse(String uri) throws IOException, SAXException {
        return FB2Parser.parse(new InputSource(uri));
    }

    public static IBook parse(InputStream stream) throws IOException, SAXException {
        return FB2Parser.parse(new InputSource(new BufferedInputStream(stream)));
    }

    private static IBook parse(InputSource source) throws IOException, SAXException {
        XMLReader reader = XMLReaderFactory.createXMLReader();
        reader.setErrorHandler(new ParseErrorHandler());
        Book book = new Book();
        book.setSystemStyleSheet(FB2Parser.getFB2StyleSheet());
        reader.setContentHandler(new FB2ContentsHandler(book));
        reader.parse(source);
        return book;
    }

    public static IBook parse(File file) throws IOException, SAXException {
        return FB2Parser.parse(file.getAbsolutePath());
    }

    private static IStyleSheet getFB2StyleSheet() {
        if (ssheet == null) {
            ssheet = new FB2StyleSheet();
        }
        return ssheet;
    }

    private static class FB2ContentsHandler
    extends DefaultHandler {
        private Locator myLocator;
        private final IBook myBook;
        private IBinaryData myBinaryData;
        private IContainerNode myContainer;
        private StringBuilder myText = new StringBuilder();
        private boolean hadOpenTag = false;
        private boolean hadCloseTag;
        private boolean parseXML = false;
        private boolean myParseText = false;

        public FB2ContentsHandler(IBook book) {
            this.myBook = book;
        }

        public void setDocumentLocator(Locator locator) {
            this.myLocator = locator;
        }

        public void characters(char[] ch, int start, int length) {
            if (!this.parseXML) {
                return;
            }
            if (!this.myParseText) {
                return;
            }
            this.myText.append(ch, start, length);
        }

        private void processTextNode() {
            if (!this.myParseText) {
                return;
            }
            String string = FB2ContentsHandler.trimStringBuilder(this.myText, this.hadOpenTag, this.hadCloseTag);
            this.myText.setLength(0);
            if (string.length() == 0) {
                return;
            }
            this.myContainer.newTextNode(string);
        }

        private boolean isParagraphTag(String tagName) {
            return tagName.equals("p") || tagName.equals("subtitle") || tagName.equals("text-author") || tagName.equals("v");
        }

        public void endElement(String uri, String localName, String qName) {
            if (!this.parseXML) {
                return;
            }
            if (!localName.equals("FictionBook")) {
                if (localName.equals("binary")) {
                    this.myBinaryData.setBase64Encoded(this.myText.toString().toCharArray());
                    this.myText.setLength(0);
                    this.myBinaryData = null;
                    this.myParseText = false;
                } else {
                    this.hadCloseTag = true;
                    this.processTextNode();
                    this.hadOpenTag = false;
                    if (this.isParagraphTag(localName)) {
                        this.myParseText = false;
                    }
                    if (this.myContainer.getTagName().equals(localName)) {
                        this.myContainer = this.myContainer.getParentNode();
                    }
                }
            }
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            if (!this.parseXML) {
                if (!localName.equals("body")) {
                    return;
                }
                this.parseXML = true;
            }
            if (!localName.equals("FictionBook")) {
                String id;
                if (localName.equals("binary")) {
                    this.myBinaryData = this.myBook.newBinaryData(attributes.getValue("id"), attributes.getValue("content-type"));
                    this.myParseText = true;
                    return;
                }
                INode node = null;
                this.hadCloseTag = false;
                this.processTextNode();
                this.hadOpenTag = true;
                if (localName.equals("body")) {
                    node = this.myBook.newBody("body", attributes.getValue("name"));
                } else if (localName.equals("title")) {
                    node = this.myContainer.newTitle(localName);
                } else if (localName.equals("image")) {
                    String href = null;
                    href = attributes.getValue("http://www.w3.org/1999/xlink", "href");
                    if (href == null) {
                        href = attributes.getValue("href");
                    }
                    if (href == null) {
                        System.err.println("Can'f find image href!");
                    }
                    IImageNode image = this.myContainer.newImage(localName, href);
                    String str = attributes.getValue("alt");
                    if (str != null) {
                        image.setText(str);
                    }
                    if ((str = attributes.getValue("title")) != null) {
                        image.setTitle(str);
                    }
                    node = image;
                } else if (this.isParagraphTag(localName)) {
                    node = this.myContainer.newContainerNode(localName);
                    this.myParseText = true;
                } else {
                    node = this.myContainer.newContainerNode(localName);
                }
                String classAttribute = localName.equals("p") ? "style" : (localName.equals("style") ? "name" : "class");
                node.setNodeClass(attributes.getValue(classAttribute));
                if (node instanceof IContainerNode) {
                    this.myContainer = node;
                }
                if ((id = attributes.getValue("id")) != null) {
                    node.setID(id);
                }
            }
        }

        private static String trimStringBuilder(StringBuilder builder, boolean trimStart, boolean trimEnd) {
            int begin;
            int length = builder.length();
            if (length == 0 || builder.charAt(0) > ' ' && builder.charAt(length - 1) > ' ') {
                return builder.toString();
            }
            int end = length - 1;
            if (trimStart) {
                for (begin = 0; begin <= end && builder.charAt(begin) <= ' '; ++begin) {
                }
            }
            if (trimEnd) {
                while (begin <= end && builder.charAt(end) <= ' ') {
                    --end;
                }
            }
            if (begin > end) {
                return "";
            }
            return builder.substring(begin, end + 1);
        }
    }
}

