/*
 * Decompiled with CFR 0.152.
 */
package jbookreader.rendering.text;

import java.io.InputStream;
import jbookreader.rendering.IDrawable;
import jbookreader.rendering.IFont;
import jbookreader.rendering.IGraphicDriver;
import jbookreader.rendering.text.StringBox;
import jbookreader.rendering.text.TextFont;
import jbookreader.style.FontDescriptor;

public class TextRenderer
implements IGraphicDriver {
    private static final int WIDTH = 80;
    private int xPosition;
    private int yPosition;

    public void addHorizontalSpace(float amount) {
        int i = 0;
        while ((float)i < amount) {
            this.append(" ");
            ++i;
        }
    }

    public void addVerticalSpace(float amount) {
        this.yPosition = (int)((float)this.yPosition + amount);
    }

    public void clear() {
        this.xPosition = 0;
        this.yPosition = 0;
    }

    public int getPaperHeight() {
        return Integer.MAX_VALUE;
    }

    public float getHorizontalPosition() {
        return this.xPosition;
    }

    public float getVerticalPosition() {
        return this.yPosition;
    }

    public int getPaperWidth() {
        return 80;
    }

    public IDrawable renderBox(int width, int height, int depth) {
        throw new UnsupportedOperationException("boxes aren't supported");
    }

    public IDrawable renderString(String s, IFont font) {
        return new StringBox(this, s);
    }

    public IDrawable renderImage(String contentType, InputStream dataStream) {
        throw new UnsupportedOperationException("image rendering isn't supported");
    }

    void append(String s) {
        System.out.print(s);
        this.xPosition += s.length();
    }

    public IFont getFont(FontDescriptor fd) {
        return new TextFont(fd.getFamily(), fd.getSize());
    }
}

