/*
 * Decompiled with CFR 0.152.
 */
package jbookreader.rendering.swing;

import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import jbookreader.rendering.IDrawable;
import jbookreader.rendering.Position;
import jbookreader.rendering.swing.JGraphicDriver;

class AWTImageAdapter
implements IDrawable {
    private final JGraphicDriver driver;
    private BufferedImage image;
    private final int width;
    private final int height;

    AWTImageAdapter(JGraphicDriver driver, String contentType, InputStream dataStream) throws IOException {
        this.driver = driver;
        Iterator<ImageReader> readers = ImageIO.getImageReadersByMIMEType(contentType);
        if (!readers.hasNext()) {
            throw new UnsupportedOperationException("content type '" + contentType + "' isn't supported");
        }
        final ImageReader reader = readers.next();
        ImageInputStream stream = ImageIO.createImageInputStream(dataStream);
        if (stream == null) {
            throw new UnsupportedOperationException("Can't create image input stream");
        }
        reader.setInput(stream, true);
        this.width = reader.getWidth(0);
        this.height = reader.getHeight(0);
        Thread imageThread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    BufferedImage readImage = reader.read(0);
                    AWTImageAdapter aWTImageAdapter = AWTImageAdapter.this;
                    synchronized (aWTImageAdapter) {
                        AWTImageAdapter.this.image = readImage;
                    }
                    AWTImageAdapter.this.driver.repaint();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
        imageThread.setPriority(1);
        imageThread.start();
    }

    AWTImageAdapter(JGraphicDriver driver, BufferedImage image) {
        this.driver = driver;
        this.image = image;
        this.width = image.getWidth();
        this.height = image.getHeight();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void draw(Position position) {
        BufferedImage drawImage = null;
        AWTImageAdapter aWTImageAdapter = this;
        synchronized (aWTImageAdapter) {
            drawImage = this.image;
        }
        if (drawImage == null) {
            this.driver.getPaperGraphics().draw(new Rectangle2D.Float(this.driver.getHorizontalPosition(), this.driver.getVerticalPosition(), this.width, this.height));
        } else {
            this.driver.getPaperGraphics().drawImage(this.image, AffineTransform.getTranslateInstance(this.driver.getHorizontalPosition(), this.driver.getVerticalPosition()), this.driver);
        }
        this.driver.horizontalPosition += (float)this.width;
    }

    public float getDepth() {
        return 0.0f;
    }

    public float getHeight() {
        return this.height;
    }

    public float getWidth(Position position) {
        return this.width;
    }
}

