/*
 * Decompiled with CFR 0.152.
 */
package jbookreader.formatengine.style.impl;

import java.util.HashMap;
import java.util.Map;
import jbookreader.style.IDimension;
import jbookreader.style.IDimensionConvertor;

class DimensionConvertor
implements IDimensionConvertor {
    private Map<String, IDimensionConvertor> convertors = new HashMap<String, IDimensionConvertor>();

    public DimensionConvertor() {
        this.convertors.put("px", new SimpleConvertor(1.0f));
    }

    public float convert(IDimension dimension) {
        IDimensionConvertor conv = this.convertors.get(dimension.getUnit());
        if (conv == null) {
            throw new IllegalArgumentException("Uknown unit passed (" + dimension.getUnit() + "): " + dimension);
        }
        return conv.convert(dimension);
    }

    private static class SimpleConvertor
    implements IDimensionConvertor {
        private final float scale;

        protected SimpleConvertor(float scale) {
            this.scale = scale;
        }

        public float convert(IDimension dimension) {
            return dimension.getValue() * this.scale;
        }
    }
}

