/*
 * Decompiled with CFR 0.152.
 */
package jbookreader.css;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import jbookreader.book.IStylesheet;
import jbookreader.css.BasicHandler;
import jbookreader.css.CSSStylesheet;
import jbookreader.css.FontSizeHandler;
import jbookreader.css.FontWeightHandler;
import jbookreader.css.IRuleHandler;
import jbookreader.css.IStyleSelector;
import jbookreader.css.StringArrayHandler;
import jbookreader.css.StyleRuleImpl;
import jbookreader.style.ERuleValueType;
import jbookreader.style.IStyleRule;
import jbookreader.style.StyleAttribute;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.DocumentHandler;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.css.sac.SACMediaList;
import org.w3c.css.sac.SelectorList;

class CSSHandler
implements DocumentHandler {
    private CSSStylesheet stylesheet = new CSSStylesheet();
    private Map<IStyleSelector, List<IStyleRule>> ruleSets;
    private static Map<String, IRuleHandler> handlers = new HashMap<String, IRuleHandler>();

    CSSHandler() {
    }

    public void comment(String text) throws CSSException {
    }

    public void startDocument(InputSource source) throws CSSException {
    }

    public void endDocument(InputSource source) throws CSSException {
    }

    public void startSelector(SelectorList selectors) throws CSSException {
        int len = selectors.getLength();
        this.ruleSets = new LinkedHashMap<IStyleSelector, List<IStyleRule>>();
        for (int i = 0; i < len; ++i) {
            this.ruleSets.put((IStyleSelector)selectors.item(i), new ArrayList());
        }
    }

    public void endSelector(SelectorList selectors) throws CSSException {
        for (Map.Entry<IStyleSelector, List<IStyleRule>> rules : this.ruleSets.entrySet()) {
            this.stylesheet.add(rules.getKey(), rules.getValue());
        }
        this.ruleSets = null;
    }

    public void property(String name, LexicalUnit value, boolean important) throws CSSException {
        try {
            if (name == null) {
                throw new CSSException("null property name");
            }
            IRuleHandler handler = handlers.get(name);
            if (handler == null) {
                System.err.println("property " + name + " not supported");
                return;
            }
            handler.handle(this, value);
        }
        catch (IllegalArgumentException e) {
            System.err.println("Error during parsing property: \"" + name + ": " + value + "\"");
            System.err.println("Caused by: ");
            e.printStackTrace();
        }
    }

    public void addRule(StyleAttribute attr, ERuleValueType type, Object value) {
        for (Map.Entry<IStyleSelector, List<IStyleRule>> rules : this.ruleSets.entrySet()) {
            rules.getValue().add(new StyleRuleImpl(attr, rules.getKey().getWeight(), type, value));
        }
    }

    public void startPage(String name, String pseudo_page) throws CSSException {
        throw new CSSException("page not supported");
    }

    public void endPage(String name, String pseudo_page) throws CSSException {
        throw new CSSException("page not supported");
    }

    public void ignorableAtRule(String atRule) throws CSSException {
        throw new CSSException("ignorable at rule");
    }

    public void importStyle(String uri, SACMediaList media, String defaultNamespaceURI) throws CSSException {
        throw new CSSException("imports not supported");
    }

    public void namespaceDeclaration(String prefix, String uri) throws CSSException {
        throw new CSSException("namespaces not supported");
    }

    public void startFontFace() throws CSSException {
        throw new CSSException("font faces not supported");
    }

    public void endFontFace() throws CSSException {
        throw new CSSException("font faces not supported");
    }

    public void startMedia(SACMediaList media) throws CSSException {
        throw new CSSException("media not supported");
    }

    public void endMedia(SACMediaList media) throws CSSException {
        throw new CSSException("media not supported");
    }

    public IStylesheet getStylesheet() {
        return this.stylesheet;
    }

    static {
        handlers.put("display", new BasicHandler(StyleAttribute.DISPLAY));
        handlers.put("font-style", new BasicHandler(StyleAttribute.FONT_STYLE));
        handlers.put("font-family", new StringArrayHandler(StyleAttribute.FONT_FAMILY));
        handlers.put("text-align", new BasicHandler(StyleAttribute.TEXT_ALIGN));
        handlers.put("font-weight", new FontWeightHandler());
        handlers.put("font-size", new FontSizeHandler());
    }
}

