/*
 * Decompiled with CFR 0.152.
 */
package jbookreader.css;

import jbookreader.css.CSSHandler;
import jbookreader.css.IRuleHandler;
import jbookreader.style.ERuleValueType;
import jbookreader.style.StyleAttribute;
import org.w3c.css.sac.LexicalUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BasicHandler
implements IRuleHandler {
    private final StyleAttribute attribute;
    private final Class<? extends Enum<?>> enumClass;

    protected BasicHandler(StyleAttribute attribute) {
        this(attribute, Enum.class.isAssignableFrom(attribute.getAttributeValueClass()) ? attribute.getAttributeValueClass() : null);
    }

    protected BasicHandler(StyleAttribute attribute, Class<? extends Enum<?>> enumClass) {
        this.attribute = attribute;
        this.enumClass = enumClass;
    }

    public StyleAttribute getAttribute() {
        return this.attribute;
    }

    @Override
    public void handle(CSSHandler handler, LexicalUnit value) {
        if (value.getLexicalUnitType() == 12 && value.getNextLexicalUnit() != null) {
            handler.addRule(this.attribute, ERuleValueType.INHERIT, null);
        } else if (this.enumClass != null && value.getLexicalUnitType() == 35 && value.getNextLexicalUnit() == null) {
            String name = value.getStringValue().toUpperCase().replace('-', '_');
            handler.addRule(this.getAttribute(), ERuleValueType.ENUM, Enum.valueOf(this.enumClass.asSubclass(Enum.class), name));
        } else {
            throw new IllegalArgumentException("Bad value for attribute '" + this.attribute + "': " + value.getLexicalUnitType() + " (" + value + ")");
        }
    }
}

