/*
 * Decompiled with CFR 0.152.
 */
package org.jbookreader.ui.swing;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import javax.swing.JComponent;
import org.jbookreader.book.bom.IBook;
import org.jbookreader.formatengine.FormatEngine;
import org.jbookreader.ui.swing.painter.SwingBookPainter;

public class JBookComponent
extends JComponent {
    private static final long serialVersionUID = -2480969864889318912L;
    private final SwingBookPainter myPainter;
    private final FormatEngine myEngine = new FormatEngine();
    private IBook myBook;
    private boolean myReformatBook;

    public JBookComponent() {
        this.myPainter = new SwingBookPainter();
        this.myEngine.setPainter(this.myPainter);
    }

    public boolean isOpaque() {
        return true;
    }

    protected void paintComponent(Graphics g) {
        if (this.isOpaque()) {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        Insets insets = this.getInsets();
        int w = this.getWidth() - insets.left - insets.right;
        int h = this.getHeight() - insets.top - insets.bottom;
        Graphics2D g2d = (Graphics2D)g.create(insets.left, insets.top, w, h);
        g2d.setBackground(this.getBackground());
        if (this.myPainter.getWidth() != (double)w) {
            this.myReformatBook = true;
        }
        this.myPainter.setGraphics(g2d, w, h);
        if (this.myBook != null) {
            this.myEngine.renderPage(this.myReformatBook);
            this.myReformatBook = false;
        }
        g2d.dispose();
    }

    public void setBook(IBook book) {
        this.myBook = book;
        this.myEngine.setBook(this.myBook);
        this.myReformatBook = true;
        this.repaint();
    }

    public void scrollPageDown() {
        this.myEngine.scrollPageDown();
        this.repaint();
    }

    public void scrollPageUp() {
        this.myEngine.scrollPageUp();
        this.repaint();
    }

    public void scrollDown(int lines) {
        this.myEngine.scrollDown(lines);
        this.repaint();
    }

    public void scrollUp(int lines) {
        this.myEngine.scrollUp(lines);
        this.repaint();
    }
}

