/*
 * Decompiled with CFR 0.152.
 */
package lumag.rtf;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import lumag.rtf.CodePageTables;
import lumag.rtf.DefaultRTFHandler;
import lumag.rtf.IRTFContentHandler;

public class RTFParser {
    private IRTFContentHandler handler;
    private int level;
    private State state = State.TEXT;
    private char[] codePageTable = CodePageTables.getCodePageTable(437);
    private StringBuilder builder = new StringBuilder();
    private String currentControl;
    private int tickedChar;
    private boolean shouldSkipGroupIfUnknown;
    private int skipLevel = Integer.MAX_VALUE;
    private long blobBytesLeft;
    private ByteArrayOutputStream blobBuffer;

    public void setCharacterSet(int cpNumber) {
        char[] table = CodePageTables.getCodePageTable(cpNumber);
        if (table != null) {
            this.codePageTable = table;
        } else {
            System.err.println("Unsupported codepage" + cpNumber);
        }
    }

    private void processControlWord(String control, boolean hasParameter, int parameter) {
        if (this.level >= this.skipLevel) {
            this.builder.setLength(0);
            return;
        }
        boolean handled = false;
        if (!(handled |= this.handler.control(control, hasParameter, hasParameter ? parameter : 1))) {
            String ctrl = control;
            if (hasParameter) {
                ctrl = ctrl + " " + parameter;
            }
            if (this.shouldSkipGroupIfUnknown) {
                System.err.println("Ignoring: " + ctrl);
                this.skipLevel = this.level;
                this.shouldSkipGroupIfUnknown = false;
            } else {
                System.err.println("Ignored unsupported control: " + ctrl);
            }
        }
    }

    public void process(byte[] bytes, int offset, int length) {
        block9: for (int i = 0; i < length; ++i) {
            byte b = bytes[offset + i];
            switch (this.state) {
                case TEXT: {
                    if (b == 123) {
                        if (this.level < this.skipLevel && this.builder.length() != 0) {
                            this.handler.string(this.builder.toString());
                        }
                        this.builder.setLength(0);
                        ++this.level;
                        if (this.level >= this.skipLevel) continue block9;
                        this.handler.startGroup();
                        continue block9;
                    }
                    if (b == 125) {
                        if (this.level < this.skipLevel && this.builder.length() != 0) {
                            this.handler.string(this.builder.toString());
                        }
                        this.builder.setLength(0);
                        --this.level;
                        if (this.level >= this.skipLevel) continue block9;
                        this.skipLevel = Integer.MAX_VALUE;
                        this.handler.endGroup();
                        continue block9;
                    }
                    if (b == 92) {
                        if (this.level < this.skipLevel && this.builder.length() != 0) {
                            this.handler.string(this.builder.toString());
                        }
                        this.builder.setLength(0);
                        this.state = State.BACKSLASH;
                        continue block9;
                    }
                    if (b == 10 || b == 13) continue block9;
                    this.putChar(b);
                    continue block9;
                }
                case BACKSLASH: {
                    if (Character.isLetter(b)) {
                        this.state = State.CONTROL;
                        this.putChar(b);
                        continue block9;
                    }
                    if (b == 39) {
                        this.state = State.BACKTICK;
                        this.tickedChar = 0;
                        continue block9;
                    }
                    if (b == 42) {
                        this.shouldSkipGroupIfUnknown = true;
                        this.state = State.TEXT;
                        continue block9;
                    }
                    this.processControlWord(String.valueOf((char)b), false, 1);
                    this.state = State.TEXT;
                    continue block9;
                }
                case CONTROL: {
                    if (Character.isLetter(b)) {
                        this.putChar(b);
                        continue block9;
                    }
                    if (Character.isDigit(b) || b == 45) {
                        this.currentControl = this.builder.toString();
                        this.builder.setLength(0);
                        this.putChar(b);
                        this.state = State.PARAMETER;
                        continue block9;
                    }
                    this.currentControl = this.builder.toString();
                    this.builder.setLength(0);
                    this.processControlWord(this.currentControl, false, 1);
                    this.currentControl = null;
                    this.state = State.TEXT;
                    if (Character.isWhitespace(b)) continue block9;
                    --i;
                    continue block9;
                }
                case PARAMETER: {
                    if (Character.isDigit(b)) {
                        this.putChar(b);
                        continue block9;
                    }
                    if (this.currentControl.equals("bin")) {
                        this.blobBytesLeft = Long.valueOf(this.builder.toString());
                        this.builder.setLength(0);
                        this.blobBuffer = this.blobBytesLeft > Integer.MAX_VALUE ? new ByteArrayOutputStream(Integer.MAX_VALUE) : new ByteArrayOutputStream((int)this.blobBytesLeft);
                        this.state = State.BLOB;
                        continue block9;
                    }
                    int parameterValue = Integer.valueOf(this.builder.toString());
                    this.builder.setLength(0);
                    this.processControlWord(this.currentControl, true, parameterValue);
                    this.currentControl = null;
                    this.state = State.TEXT;
                    if (Character.isWhitespace(b)) continue block9;
                    --i;
                    continue block9;
                }
                case BACKTICK: {
                    if (Character.digit(b, 16) == -1) {
                        this.state = State.TEXT;
                        continue block9;
                    }
                    this.tickedChar = Character.digit(b, 16);
                    this.state = State.BACKTICK_X;
                    continue block9;
                }
                case BACKTICK_X: {
                    if (Character.digit(b, 16) != -1) {
                        this.tickedChar = (this.tickedChar << 4) + Character.digit(b, 16);
                        this.putChar(this.tickedChar);
                    }
                    this.state = State.TEXT;
                    continue block9;
                }
                case BLOB: {
                    this.blobBuffer.write(b);
                    --this.blobBytesLeft;
                    if (this.blobBytesLeft != 0L) continue block9;
                    if (this.level < this.skipLevel) {
                        this.handler.binaryBlob(this.blobBuffer.toByteArray());
                    }
                    this.blobBuffer = null;
                    this.state = State.TEXT;
                }
            }
        }
    }

    private void putChar(int ch) {
        this.builder.append(this.codePageTable[ch & 0xFF]);
    }

    public void setHandler(IRTFContentHandler handler) {
        this.handler = handler;
    }

    public static void main(String[] args) throws Exception {
        int len;
        RTFParser parser = new RTFParser();
        parser.setHandler(new DefaultRTFHandler());
        BufferedInputStream stream = new BufferedInputStream(new FileInputStream(args.length > 0 ? args[0] : "tests/test.rtf"));
        byte[] buffer = new byte[1024];
        while ((len = ((InputStream)stream).read(buffer)) >= 0) {
            parser.process(buffer, 0, len);
        }
        ((InputStream)stream).close();
    }

    public int getLevel() {
        return this.level;
    }

    private static enum State {
        TEXT,
        BACKSLASH,
        CONTROL,
        PARAMETER,
        BACKTICK,
        BACKTICK_X,
        BLOB;

    }
}

