/*
 * Decompiled with CFR 0.152.
 */
package jbookreader.rendering.swing;

import java.awt.Graphics2D;
import java.awt.font.TextLayout;
import jbookreader.rendering.IDrawable;
import jbookreader.rendering.Position;
import jbookreader.rendering.swing.AWTFontAdapter;
import jbookreader.rendering.swing.JGraphicDriver;

final class SwingString
implements IDrawable {
    private final JGraphicDriver driver;
    private final TextLayout layout;
    private final int depth;
    private final int height;
    private final int width;

    SwingString(JGraphicDriver driver, String s, AWTFontAdapter font) {
        this.driver = driver;
        this.layout = new TextLayout(s, font.getFont(), this.driver.getFontRC());
        this.depth = JGraphicDriver.pixelToDimension(this.layout.getDescent());
        this.height = JGraphicDriver.pixelToDimension(this.layout.getAscent());
        this.width = JGraphicDriver.pixelToDimension(this.layout.getAdvance());
    }

    @Override
    public void draw(Position position) {
        Graphics2D g2d = this.driver.getPaperGraphics();
        if (g2d == null) {
            throw new IllegalStateException("draw with g2d = null");
        }
        this.layout.draw(g2d, JGraphicDriver.dimensionToPixel(this.driver.horizontalPosition), JGraphicDriver.dimensionToPixel(this.driver.verticalPosition + this.height));
        this.driver.horizontalPosition += this.width;
    }

    @Override
    public int getDepth() {
        return this.depth;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public int getWidth(Position position) {
        return this.width;
    }
}

