/*
 * Decompiled with CFR 0.152.
 */
package jbookreader.rendering.swing;

import java.awt.Graphics2D;
import java.awt.font.LineMetrics;
import java.awt.geom.Rectangle2D;
import jbookreader.rendering.IDrawable;
import jbookreader.rendering.Position;
import jbookreader.rendering.swing.AWTFontAdapter;
import jbookreader.rendering.swing.JGraphicDriver;

final class SimpleSwingString
implements IDrawable {
    private final JGraphicDriver driver;
    private final String string;
    private final AWTFontAdapter font;
    private int height;
    private int depth;
    private int width;

    SimpleSwingString(JGraphicDriver driver, String string, AWTFontAdapter font) {
        this.driver = driver;
        this.string = string;
        this.font = font;
        LineMetrics metrics = font.getFont().getLineMetrics(string, driver.getFontRC());
        Rectangle2D bounds = font.getFont().getStringBounds(string, driver.getFontRC());
        this.height = JGraphicDriver.pixelToDimension(metrics.getAscent());
        this.depth = JGraphicDriver.pixelToDimension(metrics.getDescent());
        this.width = JGraphicDriver.pixelToDimension((float)bounds.getWidth());
    }

    @Override
    public void draw(Position position) {
        Graphics2D graphics = this.driver.getPaperGraphics();
        if (!graphics.getFont().equals(this.font.getFont())) {
            graphics.setFont(this.font.getFont());
        }
        graphics.drawString(this.string, (int)JGraphicDriver.dimensionToPixel(this.driver.horizontalPosition), (int)JGraphicDriver.dimensionToPixel(this.driver.verticalPosition + this.height));
        this.driver.horizontalPosition += this.width;
    }

    @Override
    public int getDepth() {
        return this.depth;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public int getWidth(Position position) {
        return this.width;
    }
}

