/*
 * Decompiled with CFR 0.152.
 */
package jbookreader.rendering.swing;

import java.awt.Font;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import jbookreader.rendering.IFont;
import jbookreader.rendering.swing.JGraphicDriver;

class AWTFontAdapter
implements IFont {
    private Font font;
    private int spaceWidth;

    AWTFontAdapter(String name, int size, FontRenderContext frc, boolean bold, boolean italic) {
        int style = 0;
        if (bold) {
            style |= 1;
        }
        if (italic) {
            style |= 2;
        }
        this.font = new Font(name, style, size);
        Rectangle2D r2d = this.font.createGlyphVector(frc, new char[]{' '}).getLogicalBounds();
        this.spaceWidth = JGraphicDriver.pixelToDimension((float)(r2d.getMaxX() - r2d.getMinX()));
    }

    Font getFont() {
        return this.font;
    }

    @Override
    public int getSpaceWidth() {
        return this.spaceWidth;
    }

    @Override
    public String getFamily() {
        return this.font.getFamily();
    }

    @Override
    public int getSize() {
        return this.font.getSize();
    }

    @Override
    public boolean isBold() {
        return this.font.isBold();
    }

    @Override
    public boolean isItalic() {
        return this.font.isItalic();
    }
}

