/*
 * Decompiled with CFR 0.152.
 */
package jbookreader.formatengine.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import jbookreader.rendering.IDrawable;
import jbookreader.rendering.Position;

class HBox
implements IDrawable {
    private final List<IDrawable> elements = new ArrayList<IDrawable>();
    private int width;
    private int height;
    private int depth;

    HBox() {
    }

    @Override
    public void draw(Position position) {
        ListIterator<IDrawable> it = this.elements.listIterator();
        while (it.hasNext()) {
            IDrawable drawable = it.next();
            if (it.previousIndex() == 0) {
                drawable.draw(Position.START);
                continue;
            }
            if (it.hasNext()) {
                drawable.draw(Position.MIDDLE);
                continue;
            }
            drawable.draw(Position.END);
        }
    }

    @Override
    public int getDepth() {
        return this.depth;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public int getWidth(Position position) {
        return this.width;
    }

    public void add(int index, IDrawable drawable) {
        if (index == -1) {
            index = this.elements.size();
        }
        if (this.elements.isEmpty()) {
            this.width = drawable.getWidth(Position.START);
        } else if (index == 0) {
            IDrawable first = this.elements.get(0);
            this.width += drawable.getWidth(Position.START) + first.getWidth(Position.MIDDLE) - first.getWidth(Position.START);
        } else if (index == this.elements.size()) {
            IDrawable last = this.elements.get(this.elements.size() - 1);
            this.width += drawable.getWidth(Position.END) + last.getWidth(Position.MIDDLE) - last.getWidth(Position.END);
        } else {
            this.width += drawable.getWidth(Position.MIDDLE);
        }
        if (this.height < drawable.getHeight()) {
            this.height = drawable.getHeight();
        }
        if (this.depth < drawable.getDepth()) {
            this.depth = drawable.getDepth();
        }
        this.elements.add(index, drawable);
    }

    public void add(IDrawable drawable) {
        this.add(this.elements.size(), drawable);
    }

    public void addAll(List<IDrawable> drawables) {
        ListIterator<IDrawable> it = drawables.listIterator();
        while (it.hasNext()) {
            IDrawable drawable = it.next();
            this.width = it.previousIndex() == 0 && this.elements.size() == 0 ? (this.width += drawable.getWidth(Position.START)) : (it.hasNext() ? (this.width += drawable.getWidth(Position.MIDDLE)) : (this.width += drawable.getWidth(Position.END)));
            if (this.height < drawable.getHeight()) {
                this.height = drawable.getHeight();
            }
            if (this.depth < drawable.getDepth()) {
                this.depth = drawable.getDepth();
            }
            this.elements.add(drawable);
        }
    }

    public boolean isEmpty() {
        return this.elements.isEmpty();
    }

    public String toString() {
        return this.width + " x " + this.height + " + " + this.depth;
    }
}

