/*
 * Decompiled with CFR 0.152.
 */
package jbookreader.fileformats.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import jbookreader.book.IBinaryBlob;
import jbookreader.book.IBook;
import jbookreader.book.IBookFactory;
import jbookreader.book.IContainerNode;
import jbookreader.book.IImageNode;
import jbookreader.book.INamedNode;
import jbookreader.book.ITextNode;
import jbookreader.fileformats.IErrorHandler;
import jbookreader.fileformats.IFileFormatDescriptor;
import jbookreader.fileformats.impl.SAXParseErrorHandler;
import lumag.util.Base64;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

class FictionBook2
implements IFileFormatDescriptor {
    private final Collection<String> extensions = new ArrayList<String>();

    FictionBook2() {
        this.extensions.add(".fb2");
    }

    @Override
    public IBook parse(String uri, IErrorHandler handler, IBookFactory factory) throws SAXException, IOException {
        return this.parse(new InputSource(uri), handler, factory);
    }

    private IBook parse(InputSource source, IErrorHandler handler, IBookFactory factory) throws SAXException, IOException {
        XMLReader reader = XMLReaderFactory.createXMLReader();
        FB2ContentsHandler fb2handler = new FB2ContentsHandler(factory);
        reader.setErrorHandler(new SAXParseErrorHandler(handler));
        reader.setContentHandler(fb2handler);
        reader.parse(source);
        return fb2handler.getBook();
    }

    @Override
    public String getDescription() {
        return "FictionBook2";
    }

    @Override
    public Collection<String> getExtensions() {
        return Collections.unmodifiableCollection(this.extensions);
    }

    private static class FB2ContentsHandler
    extends DefaultHandler {
        private final IBookFactory factory;
        private final IBook book;
        private IContainerNode containerNode;
        private IBinaryBlob binaryBlob;
        private final StringBuilder textAccumulator = new StringBuilder();
        private boolean mixedNode;

        FB2ContentsHandler(IBookFactory factory) {
            this.factory = factory;
            this.book = factory.newBook();
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (localName.equals("FictionBook")) {
                return;
            }
            if (this.containerNode != null) {
                this.processTextNode();
                if (localName.equals("image")) {
                    IImageNode node = this.factory.newImageNode();
                    node.setNodeTag(localName);
                    String altText = attributes.getValue("", "alt");
                    node.setText(altText != null ? altText : "");
                    node.setHRef(attributes.getValue("http://www.w3.org/1999/xlink", "href"));
                    this.containerNode.add(node);
                } else {
                    IContainerNode node = this.factory.newContainerNode();
                    node.setNodeTag(localName);
                    this.containerNode.add(node);
                    this.containerNode = node;
                    this.mixedNode = this.isMixedNode(this.containerNode);
                }
            } else if (localName.equals("body")) {
                IContainerNode node = this.factory.newContainerNode();
                node.setNodeTag(localName);
                this.book.addBody(node, attributes.getValue("", "name"));
                this.containerNode = node;
            } else if (localName.equals("binary")) {
                this.binaryBlob = this.factory.newBinaryBlob();
                this.binaryBlob.setContentType(attributes.getValue("", "content-type"));
                this.book.addBinaryBlob(this.binaryBlob, attributes.getValue("", "id"));
                this.mixedNode = true;
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (this.containerNode != null) {
                this.processTextNode();
                if (!localName.equals("image")) {
                    this.containerNode = this.containerNode.getParentNode();
                    this.mixedNode = this.containerNode != null ? this.isMixedNode(this.containerNode) : false;
                }
            } else if (localName.equals("binary")) {
                byte[] data = Base64.decode(this.textAccumulator.toString());
                this.textAccumulator.setLength(0);
                this.binaryBlob.setData(data);
                this.binaryBlob = null;
                this.mixedNode = false;
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.mixedNode) {
                this.textAccumulator.append(ch, start, length);
            }
        }

        private boolean isMixedNode(INamedNode node) {
            String tag = node.getNodeTag();
            return tag.equals("a") || tag.equals("code") || tag.equals("emphasis") || tag.equals("p") || tag.equals("strikethrough") || tag.equals("strong") || tag.equals("style") || tag.equals("sub") || tag.equals("subtitle") || tag.equals("sup") || tag.equals("td") || tag.equals("text-author") || tag.equals("th") || tag.equals("v");
            {
            }
        }

        private void processTextNode() {
            if (this.textAccumulator.length() == 0) {
                return;
            }
            ITextNode node = this.factory.newTextNode();
            String str = this.textAccumulator.toString();
            this.textAccumulator.setLength(0);
            node.setText(str);
            this.containerNode.add(node);
        }

        public IBook getBook() {
            return this.book;
        }
    }
}

