/*
 * Decompiled with CFR 0.152.
 */
package jbookreader.ui.swing;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import javax.swing.SwingUtilities;
import jbookreader.book.IBook;
import jbookreader.book.IBookFactory;
import jbookreader.book.IStylesheet;
import jbookreader.css.CSSParser;
import jbookreader.fileformats.IErrorHandler;
import jbookreader.fileformats.IFileFormatDescriptor;
import jbookreader.fileformats.UnknownFormatException;
import jbookreader.fileformats.impl.FileFormatsLibrary;
import jbookreader.formatengine.ICompositor;
import jbookreader.formatengine.IFormatEngine;
import jbookreader.rendering.swing.JGraphicDriver;
import jbookreader.ui.swing.MainWindow;
import lumag.util.ClassFactory;
import org.xml.sax.SAXException;

public class Main {
    public static void main(String[] args) {
        ClassFactory.loadProperies("jbookreader");
        final String filename = args.length == 0 ? "tests/simple.fb2" : args[0];
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                MainWindow window = new MainWindow();
                final JGraphicDriver driver = window.getGraphicDriver();
                driver.setCompositor(ClassFactory.createClass(ICompositor.class, "jbookreader.compositor"));
                driver.setFormatEngine(ClassFactory.createClass(IFormatEngine.class, "jbookreader.formatengine"));
                new Thread(new Runnable(){

                    public void run() {
                        IErrorHandler handler = new IErrorHandler(this){
                            final /* synthetic */ 1 this$2;
                            {
                                this.this$2 = var1_1;
                            }

                            public boolean error(boolean fatal, String message) {
                                System.err.println(message);
                                return true;
                            }

                            public void warning(String message) {
                                System.err.println(message);
                            }
                        };
                        try {
                            IStylesheet defaultStylesheet = CSSParser.parse("resources/css/default.css");
                            IFileFormatDescriptor fileFormat = FileFormatsLibrary.getDescriptorForFile(filename);
                            IBook book = fileFormat.parse(filename, handler, ClassFactory.createClass(IBookFactory.class, "jbookreader.factory.book"));
                            SwingUtilities.invokeAndWait(new Runnable(this, driver, defaultStylesheet, fileFormat, book){
                                final /* synthetic */ 1 this$2;
                                private final /* synthetic */ JGraphicDriver val$driver;
                                private final /* synthetic */ IStylesheet val$defaultStylesheet;
                                private final /* synthetic */ IFileFormatDescriptor val$fileFormat;
                                private final /* synthetic */ IBook val$book;
                                {
                                    this.this$2 = var1_1;
                                    this.val$driver = jGraphicDriver;
                                    this.val$defaultStylesheet = iStylesheet;
                                    this.val$fileFormat = iFileFormatDescriptor;
                                    this.val$book = iBook;
                                }

                                public void run() {
                                    this.val$driver.setDefaultStylesheet(this.val$defaultStylesheet);
                                    this.val$driver.setFormatStylesheet(this.val$fileFormat.getStylesheet());
                                    this.val$driver.setBook(this.val$book);
                                    this.val$driver.repaint();
                                }
                            });
                        }
                        catch (SAXException e) {
                            e.printStackTrace();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        catch (InvocationTargetException e) {
                            e.printStackTrace();
                        }
                        catch (UnknownFormatException e) {
                            e.printStackTrace();
                        }
                    }
                }).start();
            }
        });
    }
}

