/*
 * Decompiled with CFR 0.152.
 */
package jbookreader.formatengine.style.impl;

import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import jbookreader.formatengine.IStyleConfig;
import jbookreader.formatengine.style.impl.DimensionConvertor;
import jbookreader.formatengine.style.impl.EnumValueComputer;
import jbookreader.formatengine.style.impl.FontSizeValueComputer;
import jbookreader.formatengine.style.impl.FontWeightValueComputer;
import jbookreader.formatengine.style.impl.IStyleValueComputer;
import jbookreader.formatengine.style.impl.IntegerValueComputer;
import jbookreader.formatengine.style.impl.StringArrayValueComputer;
import jbookreader.style.ERuleValueType;
import jbookreader.style.IDimensionConvertor;
import jbookreader.style.IStyleRule;
import jbookreader.style.StyleAttribute;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class StyleStackState {
    private static Map<StyleAttribute, IStyleValueComputer> specials = new EnumMap<StyleAttribute, IStyleValueComputer>(StyleAttribute.class);
    private static Map<Class<?>, IStyleValueComputer> generics;
    private static final IStyleRule inheritRule;
    private final Map<StyleAttribute, Object> attributes;
    private final IDimensionConvertor convertor = new DimensionConvertor();

    static {
        specials.put(StyleAttribute.FONT_WEIGHT, new FontWeightValueComputer());
        specials.put(StyleAttribute.FONT_SIZE, new FontSizeValueComputer());
        generics = new HashMap();
        generics.put(Integer.class, new IntegerValueComputer());
        generics.put(String[].class, new StringArrayValueComputer());
        generics.put(Enum.class, new EnumValueComputer());
        inheritRule = new IStyleRule(){

            @Override
            public StyleAttribute getAttribute() {
                throw new InternalError("Attribute requested for special inheritance rule");
            }

            @Override
            public <T> T getValue(Class<T> klass) throws ClassCastException {
                return null;
            }

            @Override
            public ERuleValueType getValueType() {
                return ERuleValueType.INHERIT;
            }

            @Override
            public long getWeight() {
                return 0L;
            }
        };
    }

    StyleStackState(IStyleConfig config) {
        this.attributes = new EnumMap<StyleAttribute, Object>(StyleAttribute.class);
        StyleAttribute[] styleAttributeArray = StyleAttribute.values();
        int n = 0;
        int n2 = styleAttributeArray.length;
        while (n < n2) {
            StyleAttribute attribute = styleAttributeArray[n];
            IStyleValueComputer computer = this.findComputer(attribute);
            this.attributes.put(attribute, computer.compute(attribute, attribute, null, config));
            ++n;
        }
    }

    StyleStackState(StyleStackState oldState, Map<StyleAttribute, IStyleRule> rules, IStyleConfig config) {
        this.attributes = new EnumMap<StyleAttribute, Object>(StyleAttribute.class);
        StyleAttribute[] styleAttributeArray = StyleAttribute.values();
        int n = 0;
        int n2 = styleAttributeArray.length;
        while (n < n2) {
            StyleAttribute attribute = styleAttributeArray[n];
            IStyleValueComputer computer = this.findComputer(attribute);
            IStyleRule rule = rules.get(attribute);
            if (rule == null) {
                rule = attribute.isInherit() ? inheritRule : attribute;
            }
            this.attributes.put(attribute, computer.compute(attribute, rule, oldState, config));
            ++n;
        }
    }

    private IStyleValueComputer findComputer(StyleAttribute attrib) throws InternalError {
        IStyleValueComputer computer = specials.get(attrib);
        if (computer == null) {
            Class<?> klass = attrib.getAttributeValueClass();
            while (computer == null && klass != null) {
                computer = generics.get(klass);
                klass = klass.getSuperclass();
            }
        }
        if (computer == null) {
            throw new InternalError("Can't get value computer for attribute " + attrib);
        }
        return computer;
    }

    <T> T getAttributeValue(StyleAttribute attribute) {
        return (T)attribute.getAttributeValueClass().cast(this.attributes.get(attribute));
    }

    void setAttributeValue(StyleAttribute attribute, Object object) {
        this.attributes.put(attribute, attribute.getAttributeValueClass().cast(object));
    }

    IDimensionConvertor getDimensionConvertor() {
        return this.convertor;
    }
}

