/*
 * Decompiled with CFR 0.152.
 */
package jbookreader.formatengine.style.impl;

import jbookreader.formatengine.IStyleConfig;
import jbookreader.formatengine.style.impl.IntegerValueComputer;
import jbookreader.formatengine.style.impl.StyleStackState;
import jbookreader.style.FontWeight;
import jbookreader.style.IStyleRule;
import jbookreader.style.StyleAttribute;

class FontWeightValueComputer
extends IntegerValueComputer {
    FontWeightValueComputer() {
    }

    protected Object handleEnumValue(StyleAttribute attribute, IStyleRule rule, StyleStackState oldState, IStyleConfig config) {
        FontWeight weight = rule.getValue(FontWeight.class);
        switch (weight) {
            case NORMAL: {
                return 400;
            }
            case BOLD: {
                return 700;
            }
            case LIGHTER: {
                int val = (Integer)oldState.getAttributeValue(attribute);
                if (val - 100 < 100) {
                    return 100;
                }
                return val - 100;
            }
            case BOLDER: {
                int val = (Integer)oldState.getAttributeValue(attribute);
                if (val + 100 > 900) {
                    return 900;
                }
                return val + 100;
            }
        }
        throw new InternalError("Unhandled font-weight value: " + (Object)((Object)weight));
    }
}

