/*
 * Decompiled with CFR 0.152.
 */
package jbookreader.formatengine.style.impl;

import jbookreader.formatengine.IStyleConfig;
import jbookreader.formatengine.style.impl.IStyleValueComputer;
import jbookreader.formatengine.style.impl.StyleStackState;
import jbookreader.style.IStyleRule;
import jbookreader.style.StyleAttribute;

abstract class BasicStyleValueComputer
implements IStyleValueComputer {
    BasicStyleValueComputer() {
    }

    public Object compute(StyleAttribute attribute, IStyleRule rule, StyleStackState oldState, IStyleConfig config) {
        switch (rule.getValueType()) {
            case INHERIT: {
                return oldState.getAttributeValue(attribute);
            }
            case STRING_ARRAY: {
                return this.handleStringArray(attribute, rule, oldState, config);
            }
            case ENUM: {
                return this.handleEnumValue(attribute, rule, oldState, config);
            }
            case INTEGER: {
                return this.handleInteger(attribute, rule, oldState, config);
            }
            case DIMENSION: {
                return this.handleDimension(attribute, rule, oldState, config);
            }
        }
        throw new InternalError("Undandled rule value type: " + (Object)((Object)rule.getValueType()));
    }

    protected Object handleDimension(StyleAttribute attribute, IStyleRule rule, StyleStackState oldState, IStyleConfig config) {
        throw new IllegalArgumentException("Bad " + attribute + " rule: " + rule);
    }

    protected Object handleStringArray(StyleAttribute attribute, IStyleRule rule, StyleStackState oldState, IStyleConfig config) {
        throw new IllegalArgumentException("Bad " + attribute + " rule: " + rule);
    }

    protected Object handleEnumValue(StyleAttribute attribute, IStyleRule rule, StyleStackState oldState, IStyleConfig config) {
        throw new IllegalArgumentException("Bad " + attribute + " rule: " + rule);
    }

    protected Object handleInteger(StyleAttribute attribute, IStyleRule rule, StyleStackState oldState, IStyleConfig config) {
        throw new IllegalArgumentException("Bad " + attribute + " rule: " + rule);
    }
}

