/*
 * Decompiled with CFR 0.152.
 */
package jbookreader.fileformats.impl;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipInputStream;
import jbookreader.book.IBinaryBlob;
import jbookreader.book.IBook;
import jbookreader.book.IBookFactory;
import jbookreader.book.IContainerNode;
import jbookreader.book.IImageNode;
import jbookreader.book.INamedNode;
import jbookreader.book.INode;
import jbookreader.book.IStylesheet;
import jbookreader.book.ITextNode;
import jbookreader.css.CSSParser;
import jbookreader.fileformats.IErrorHandler;
import jbookreader.fileformats.IFileFormatDescriptor;
import jbookreader.fileformats.impl.SAXParseErrorHandler;
import jbookreader.style.IStyleRule;
import lumag.util.Base64;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FictionBook2
implements IFileFormatDescriptor {
    private final Collection<String> extensions = new ArrayList<String>();
    private IStylesheet stylesheet;

    FictionBook2() {
        this.extensions.add(".fb2");
        this.extensions.add(".fb2.zip");
        this.extensions.add(".fbz");
    }

    private InputStream constructInputStream(InputStream ins) throws IOException {
        InputStream stream = ins.markSupported() ? ins : new BufferedInputStream(ins);
        stream.mark(2);
        byte[] header = new byte[2];
        stream.read(header);
        stream.reset();
        if (header[0] == 80 && header[1] == 75) {
            ZipInputStream zip = new ZipInputStream(stream);
            zip.getNextEntry();
            return zip;
        }
        return stream;
    }

    @Override
    public IBook parse(String uri, IErrorHandler handler, IBookFactory factory) throws SAXException, IOException {
        InputSource source = new InputSource();
        source.setByteStream(this.constructInputStream(new BufferedInputStream(new FileInputStream(uri))));
        source.setSystemId(uri);
        return this.parse(source, handler, factory);
    }

    private IBook parse(InputSource source, IErrorHandler handler, IBookFactory factory) throws SAXException, IOException {
        XMLReader reader = XMLReaderFactory.createXMLReader();
        FB2ContentsHandler fb2handler = new FB2ContentsHandler(factory);
        reader.setErrorHandler(new SAXParseErrorHandler(handler));
        reader.setContentHandler(fb2handler);
        reader.parse(source);
        return fb2handler.getBook();
    }

    @Override
    public String getDescription() {
        return "FictionBook2";
    }

    @Override
    public Collection<String> getExtensions() {
        return Collections.unmodifiableCollection(this.extensions);
    }

    @Override
    public IStylesheet getStylesheet() {
        if (this.stylesheet == null) {
            try {
                this.stylesheet = CSSParser.parse("resources/css/fb2.css");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (this.stylesheet == null) {
            return new IStylesheet(){
                private List<IStyleRule> list = new LinkedList<IStyleRule>();

                @Override
                public List<IStyleRule> getApplicableRules(INode node) {
                    return Collections.unmodifiableList(this.list);
                }
            };
        }
        return this.stylesheet;
    }

    private static class FB2ContentsHandler
    extends DefaultHandler {
        private static final Set<String> MIXED_NODES;
        private final IBookFactory factory;
        private final IBook book;
        private IContainerNode containerNode;
        private IBinaryBlob binaryBlob;
        private final StringBuilder textAccumulator = new StringBuilder();
        private boolean mixedNode;

        static {
            String[] mixedNodeTags;
            MIXED_NODES = new HashSet<String>();
            String[] stringArray = mixedNodeTags = new String[]{"a", "code", "emphasis", "p", "strikethrough", "strong", "style", "sub", "subtitle", "sup", "td", "text-author", "th", "v"};
            int n = 0;
            int n2 = stringArray.length;
            while (n < n2) {
                String tag = stringArray[n];
                MIXED_NODES.add(tag);
                ++n;
            }
        }

        FB2ContentsHandler(IBookFactory factory) {
            this.factory = factory;
            this.book = factory.newBook();
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (localName.equals("FictionBook")) {
                return;
            }
            if (this.containerNode != null) {
                this.processTextNode();
                if (localName.equals("image")) {
                    IImageNode node = this.factory.newImageNode();
                    node.setNodeTag(localName);
                    String altText = attributes.getValue("", "alt");
                    node.setText(altText != null ? altText : "");
                    node.setHRef(attributes.getValue("http://www.w3.org/1999/xlink", "href"));
                    this.containerNode.add(node);
                } else {
                    IContainerNode node = this.factory.newContainerNode();
                    node.setNodeTag(localName);
                    this.containerNode.add(node);
                    this.containerNode = node;
                    this.mixedNode = this.isMixedNode(this.containerNode);
                }
            } else if (localName.equals("body")) {
                IContainerNode node = this.factory.newContainerNode();
                node.setNodeTag(localName);
                this.book.addBody(node, attributes.getValue("", "name"));
                this.containerNode = node;
            } else if (localName.equals("binary")) {
                this.binaryBlob = this.factory.newBinaryBlob();
                this.binaryBlob.setContentType(attributes.getValue("", "content-type"));
                this.book.addBinaryBlob(this.binaryBlob, attributes.getValue("", "id"));
                this.mixedNode = true;
            }
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (this.containerNode != null) {
                this.processTextNode();
                if (!localName.equals("image")) {
                    this.containerNode = this.containerNode.getParentNode();
                    this.mixedNode = this.containerNode != null ? this.isMixedNode(this.containerNode) : false;
                }
            } else if (localName.equals("binary")) {
                byte[] data = Base64.decode(this.textAccumulator.toString());
                this.textAccumulator.setLength(0);
                this.binaryBlob.setData(data);
                this.binaryBlob = null;
                this.mixedNode = false;
            }
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.mixedNode) {
                this.textAccumulator.append(ch, start, length);
            }
        }

        private boolean isMixedNode(INamedNode node) {
            String tag = node.getNodeTag();
            return MIXED_NODES.contains(tag);
        }

        private void processTextNode() {
            if (this.textAccumulator.length() == 0) {
                return;
            }
            ITextNode node = this.factory.newTextNode();
            String str = this.textAccumulator.toString();
            this.textAccumulator.setLength(0);
            node.setText(str);
            this.containerNode.add(node);
        }

        public IBook getBook() {
            return this.book;
        }
    }
}

