/*
 * Decompiled with CFR 0.152.
 */
package jbookreader.css;

import java.util.ArrayList;
import jbookreader.css.CSSHandler;
import jbookreader.css.IRuleHandler;
import jbookreader.style.ERuleValueType;
import jbookreader.style.StyleAttribute;
import org.w3c.css.sac.LexicalUnit;

class StringArrayHandler
implements IRuleHandler {
    private final StyleAttribute attribute;

    public StringArrayHandler(StyleAttribute attribute) {
        this.attribute = attribute;
    }

    public void handle(CSSHandler handler, LexicalUnit value) {
        if (value.getLexicalUnitType() == 12) {
            handler.addRule(this.attribute, ERuleValueType.INHERIT, null);
        }
        ArrayList<String> strings = new ArrayList<String>();
        LexicalUnit lex = value;
        while (lex != null) {
            switch (lex.getLexicalUnitType()) {
                case 0: {
                    break;
                }
                case 35: 
                case 36: {
                    strings.add(lex.getStringValue());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Bad value type: " + value.getLexicalUnitType() + " (" + value + ")");
                }
            }
            lex = lex.getNextLexicalUnit();
        }
        handler.addRule(this.attribute, ERuleValueType.STRING_ARRAY, strings.toArray(new String[strings.size()]));
    }
}

