/*
 * Decompiled with CFR 0.152.
 */
package lumag.util;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public final class ClassFactory {
    private static Properties defaults = new Properties();

    private ClassFactory() {
    }

    private static String findClassName(String property) {
        String className = null;
        try {
            className = System.getProperty(property);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        if (className == null) {
            className = defaults.getProperty(property);
        }
        if (className == null) {
            throw new IllegalArgumentException("Can't find a class for '" + property + "' property");
        }
        return className;
    }

    public static void loadProperies(String pkg) {
        String resourceName = "";
        if (pkg != null && !"".equals(pkg)) {
            resourceName = pkg + ".";
        }
        resourceName = resourceName.replace('.', '/');
        resourceName = resourceName + "classes.properties";
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            loader = ClassLoader.class.getClassLoader();
        }
        try {
            InputStream stream = loader == null ? new FileInputStream(resourceName) : loader.getResourceAsStream(resourceName);
            defaults.load(stream);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static <T> T createClass(Class<T> intf, String property) {
        String className = ClassFactory.findClassName(property);
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        try {
            Class<T> klass = loader == null ? Class.forName(className).asSubclass(intf) : loader.loadClass(className).asSubclass(intf);
            return klass.newInstance();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            throw new UnknownError(e.getMessage());
        }
        catch (InstantiationException e) {
            e.printStackTrace();
            throw new UnknownError(e.getMessage());
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            throw new UnknownError(e.getMessage());
        }
    }
}

