/*
 * Decompiled with CFR 0.152.
 */
package jbookreader.style.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import jbookreader.book.IContainerNode;
import jbookreader.book.IImageNode;
import jbookreader.book.INode;
import jbookreader.book.INodeVisitor;
import jbookreader.book.ITextNode;
import jbookreader.style.Alignment;
import jbookreader.style.Display;
import jbookreader.style.IStyleStack;
import jbookreader.style.IStylesheet;
import jbookreader.style.impl.StyleStackState;

public class FB2StyleStackImpl
implements IStyleStack {
    private List<StyleStackState> stateStack = new ArrayList<StyleStackState>();
    private StyleStackState currentState = new StyleStackState();
    private final INodeVisitor visitor = new FB2StyleNodeVisitor();

    public FB2StyleStackImpl() {
        this.stateStack.add(this.currentState);
    }

    @Override
    public void push(INode node) {
        this.currentState = this.currentState.clone();
        node.accept(this.visitor);
        this.stateStack.add(this.currentState);
    }

    @Override
    public void pop() {
        this.stateStack.remove(this.currentState);
        if (this.stateStack.isEmpty()) {
            this.currentState = new StyleStackState();
            this.stateStack.add(this.currentState);
            System.err.println("style stack became empty!");
        } else {
            this.currentState = this.stateStack.get(this.stateStack.size() - 1);
        }
    }

    @Override
    public Display getDisplay() {
        return this.currentState.display;
    }

    @Override
    public Alignment getTextAlign() {
        return this.currentState.textAlignment;
    }

    @Override
    public List<String> getFontFamily() {
        return Collections.unmodifiableList(this.currentState.fontFamily);
    }

    @Override
    public String getFirstFontFamily() {
        return this.currentState.fontFamily.get(0);
    }

    @Override
    public int getFontSize() {
        return this.currentState.fontSize;
    }

    @Override
    public int getFontWeight() {
        return this.currentState.fontWeight;
    }

    @Override
    public IStylesheet.FontStyle getFontStyle() {
        return this.currentState.fontStyle;
    }

    private class FB2StyleNodeVisitor
    implements INodeVisitor {
        private FB2StyleNodeVisitor() {
        }

        @Override
        public boolean visitContainerNode(IContainerNode node) {
            ((FB2StyleStackImpl)FB2StyleStackImpl.this).currentState.nodeTag = node.getNodeTag();
            ((FB2StyleStackImpl)FB2StyleStackImpl.this).currentState.nodeClass = node.getNodeClass();
            this.applyStyles();
            return false;
        }

        @Override
        public boolean visitImageNode(IImageNode node) {
            ((FB2StyleStackImpl)FB2StyleStackImpl.this).currentState.nodeTag = node.getNodeTag();
            ((FB2StyleStackImpl)FB2StyleStackImpl.this).currentState.nodeClass = node.getNodeClass();
            this.applyStyles();
            return false;
        }

        @Override
        public boolean visitTextNode(ITextNode node) {
            ((FB2StyleStackImpl)FB2StyleStackImpl.this).currentState.nodeTag = "#text";
            ((FB2StyleStackImpl)FB2StyleStackImpl.this).currentState.nodeClass = null;
            ((FB2StyleStackImpl)FB2StyleStackImpl.this).currentState.display = Display.INLINE;
            return false;
        }

        private void applyStyles() {
            ((FB2StyleStackImpl)FB2StyleStackImpl.this).currentState.display = this.isInlineNode() ? Display.INLINE : Display.BLOCK;
            if ("title".equals(((FB2StyleStackImpl)FB2StyleStackImpl.this).currentState.nodeTag)) {
                ((FB2StyleStackImpl)FB2StyleStackImpl.this).currentState.textAlignment = Alignment.CENTER;
                ((FB2StyleStackImpl)FB2StyleStackImpl.this).currentState.fontFamily = new ArrayList<String>();
                ((FB2StyleStackImpl)FB2StyleStackImpl.this).currentState.fontFamily.add("Sans");
                ((FB2StyleStackImpl)FB2StyleStackImpl.this).currentState.fontSize = (int)((double)((FB2StyleStackImpl)FB2StyleStackImpl.this).currentState.fontSize * 1.5 * 1.5);
            } else if ("strong".equals(((FB2StyleStackImpl)FB2StyleStackImpl.this).currentState.nodeTag)) {
                ((FB2StyleStackImpl)FB2StyleStackImpl.this).currentState.fontWeight = 700;
            } else if ("emphasis".equals(((FB2StyleStackImpl)FB2StyleStackImpl.this).currentState.nodeTag)) {
                ((FB2StyleStackImpl)FB2StyleStackImpl.this).currentState.fontStyle = IStylesheet.FontStyle.ITALIC;
            }
        }

        private boolean isInlineNode() {
            String tag = ((FB2StyleStackImpl)FB2StyleStackImpl.this).currentState.nodeTag;
            if ("strong".equals(tag) || "emphasis".equals(tag) || "style".equals(tag) || "a".equals(tag) || "strikethrough".equals(tag) || "sub".equals(tag) || "sup".equals(tag) || "code".equals(tag) || "#text".equals(tag)) {
                return true;
            }
            if ("image".equals(tag)) {
                ListIterator it = FB2StyleStackImpl.this.stateStack.listIterator(FB2StyleStackImpl.this.stateStack.size());
                while (it.hasPrevious()) {
                    StyleStackState state = (StyleStackState)it.previous();
                    if (!"p".equals(state.nodeTag) && !"v".equals(state.nodeTag)) continue;
                    return true;
                }
                return false;
            }
            return false;
        }
    }
}

