/*
 * Decompiled with CFR 0.152.
 */
package jbookreader.rendering.text;

import java.io.InputStream;
import jbookreader.rendering.IDrawable;
import jbookreader.rendering.IFont;
import jbookreader.rendering.IGraphicDriver;
import jbookreader.rendering.text.StringBox;
import jbookreader.rendering.text.TextFont;

public class TextRenderer
implements IGraphicDriver {
    private static final int WIDTH = 80;
    private int xPosition;
    private int yPosition;

    @Override
    public void addHorizontalSpace(int amount) {
        for (int i = 0; i < amount; ++i) {
            this.append(" ");
        }
    }

    @Override
    public void addVerticalSpace(int amount) {
        this.yPosition += amount;
    }

    @Override
    public void clear() {
        this.xPosition = 0;
        this.yPosition = 0;
    }

    @Override
    public int getPaperHeight() {
        return Integer.MAX_VALUE;
    }

    @Override
    public int getHorizontalPosition() {
        return this.xPosition;
    }

    @Override
    public int getVerticalPosition() {
        return this.yPosition;
    }

    @Override
    public int getPaperWidth() {
        return 80;
    }

    @Override
    public IDrawable renderBox(int width, int height, int depth) {
        throw new UnsupportedOperationException("boxes aren't supported");
    }

    @Override
    public IDrawable renderString(String s, IFont font) {
        return new StringBox(this, s);
    }

    @Override
    public IDrawable renderImage(String contentType, InputStream dataStream) {
        throw new UnsupportedOperationException("image rendering isn't supported");
    }

    void append(String s) {
        System.out.print(s);
        this.xPosition += s.length();
    }

    @Override
    public IFont getFont(String name, int size, boolean bold, boolean italic) {
        return new TextFont(name, size);
    }
}

